/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.Writer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FilterWriter
extends Writer {
    protected Writer out;

    protected FilterWriter(Writer writer) {
        super(writer);
        this.out = writer;
    }

    private void checkIfStillOpen() throws IOException {
        if (this.out == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int n) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.out.write(n);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > cArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.out.write(cArray, n, n2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(String string, int n, int n2) throws IOException {
        if (n2 < 0 || n < 0 || n + n2 > string.length()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.out.write(string, n, n2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.checkIfStillOpen();
            this.out.flush();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out != null) {
                this.out.close();
                this.out = null;
            }
            return;
        }
    }
}

