/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import kaffe.lang.ThreadStack;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInputStream
extends InputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final boolean DOTRACE = false;
    private static final ObjectStreamClass defaultClassDesc = new ObjectStreamClass();
    private static final int firstKey = 0x7E0000;
    private final ArrayList objectReferences;
    private final BlockDataInputStream blockDataInputStream;
    private final DataInputStream formattedInputStream;
    private boolean enableResolve;
    private Object currentObject;
    private ObjectStreamClass currentStreamClass;

    public ObjectInputStream(InputStream inputStream) throws IOException, StreamCorruptedException {
        this.Block$();
        this.blockDataInputStream = new BlockDataInputStream(inputStream);
        this.formattedInputStream = new DataInputStream(this.blockDataInputStream);
        this.readStreamHeader();
        this.blockDataInputStream.enableBuffering(true);
    }

    protected ObjectInputStream() {
        this.Block$();
        this.blockDataInputStream = null;
        this.formattedInputStream = null;
        throw new NotImplemented(new StringBuffer().append(Class.forName("java.io.ObjectInputStream").getName()).append(".<init>()").toString());
    }

    @Override
    public void close() throws IOException {
        this.formattedInputStream.close();
    }

    @Override
    public int available() throws IOException {
        return this.formattedInputStream.available();
    }

    @Override
    public int read() throws IOException {
        return this.formattedInputStream.read();
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.formattedInputStream.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.formattedInputStream.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.formattedInputStream.readUnsignedByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.formattedInputStream.readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.formattedInputStream.readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.formattedInputStream.readFloat();
    }

    @Override
    public void readFully(byte[] byArray) throws IOException {
        this.formattedInputStream.readFully(byArray, 0, byArray.length);
    }

    @Override
    public void readFully(byte[] byArray, int n, int n2) throws IOException {
        this.formattedInputStream.readFully(byArray, n, n2);
    }

    @Override
    public int readInt() throws IOException {
        return this.formattedInputStream.readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.formattedInputStream.readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.formattedInputStream.readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.formattedInputStream.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.formattedInputStream.readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.formattedInputStream.readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.formattedInputStream.skipBytes(n);
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        short s = this.readShort();
        if (s != -21267) {
            throw new StreamCorruptedException(new StringBuffer().append("bad magic in stream header (").append(s).append(", expected ").append(-21267).append(")").toString());
        }
        s = this.readShort();
        if (s != 5) {
            throw new StreamCorruptedException(new StringBuffer().append("bad version in stream header (").append(s).append(", expected ").append(5).append(")").toString());
        }
    }

    protected boolean enableResolveObject(boolean bl) throws SecurityException {
        boolean bl2 = this.enableResolve;
        this.enableResolve = bl;
        return bl2;
    }

    protected Object resolveObject(Object object) throws IOException {
        return object;
    }

    protected Class resolveClass(ObjectStreamClass objectStreamClass) throws IOException, ClassNotFoundException {
        return this.resolveClassInternal(objectStreamClass.getName());
    }

    Class resolveClassInternal(String string) throws IOException, ClassNotFoundException {
        return Class.forName(string, false, ThreadStack.firstClassLoader());
    }

    @Override
    public final Object readObject() throws OptionalDataException, ClassNotFoundException, IOException {
        Object object = this.readObjectInternal();
        if (this.enableResolve) {
            object = this.resolveObject(object);
        }
        return object;
    }

    private Object readObjectInternal() throws OptionalDataException, ClassNotFoundException, IOException {
        boolean bl = this.blockDataInputStream.enableBuffering(false);
        Object object = null;
        int n = this.readUnsignedByte();
        switch (n) {
            case 112: {
                object = null;
                break;
            }
            case 116: {
                object = this.readUTF();
                this.makeObjectReference(object);
                break;
            }
            case 113: {
                object = this.getObjectFromReference(this.readInt());
                break;
            }
            case 114: {
                object = this.getStreamClass();
                break;
            }
            case 115: {
                object = this.getObject();
                break;
            }
            case 117: {
                object = this.getArray();
                break;
            }
            case 118: {
                object = this.getClassOnly();
                break;
            }
            case 121: {
                this.resetObjectReferences();
                return this.readObject();
            }
            case 119: {
                int n2 = this.read();
                if (n2 == -1) {
                    throw new StreamCorruptedException("incomplete block count");
                }
                throw new OptionalDataException(n2);
            }
            case 122: {
                int n3 = this.read();
                int n4 = this.read();
                int n5 = this.read();
                int n6 = this.read();
                if (n3 == -1 || n4 == -1 || n5 == -1 || n6 == -1) {
                    throw new StreamCorruptedException("incomplete block count");
                }
                int n7 = n3 << 24 | n4 << 16 | n5 << 8 | n6;
                throw new OptionalDataException(n7);
            }
            default: {
                throw new StreamCorruptedException(new StringBuffer().append("unexpected ObjectStreamConstant TC_ token: 0x").append(Integer.toHexString(n)).toString());
            }
        }
        this.blockDataInputStream.enableBuffering(bl);
        return object;
    }

    public synchronized void registerValidation(ObjectInputValidation objectInputValidation, int n) throws NotActiveException, InvalidObjectException {
        throw new NotImplemented(new StringBuffer().append(Class.forName("java.io.ObjectInputStream").getName()).append(".registerValidation()").toString());
    }

    public void defaultReadObject() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentStreamClass == null) {
            throw new NotActiveException();
        }
        boolean bl = this.blockDataInputStream.enableBuffering(false);
        this.currentStreamClass.defaultReadObject(this.currentObject, this);
        this.blockDataInputStream.enableBuffering(bl);
    }

    public GetField readFields() throws IOException, ClassNotFoundException, NotActiveException {
        if (this.currentObject == null || this.currentStreamClass == null) {
            throw new NotActiveException();
        }
        boolean bl = this.blockDataInputStream.enableBuffering(false);
        GetField getField = this.currentStreamClass.readFields(this);
        this.blockDataInputStream.enableBuffering(bl);
        return getField;
    }

    private Object getObjectFromReference(int n) throws StreamCorruptedException {
        try {
            return this.objectReferences.get(n - 0x7E0000);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new StreamCorruptedException("reference to unknown object");
        }
    }

    void makeObjectReference(Object object) {
        this.objectReferences.add(object);
    }

    private void resetObjectReferences() {
        this.objectReferences.clear();
    }

    boolean enableBuffering(boolean bl) {
        return this.blockDataInputStream.enableBuffering(bl);
    }

    private Object getObject() throws StreamCorruptedException, OptionalDataException, InvalidClassException {
        try {
            ObjectStreamClass objectStreamClass;
            try {
                objectStreamClass = (ObjectStreamClass)this.readObject();
            }
            catch (InvalidClassException invalidClassException) {
                throw invalidClassException;
            }
            catch (StreamCorruptedException streamCorruptedException) {
                throw streamCorruptedException;
            }
            catch (IOException iOException) {
                throw new StreamCorruptedException(new StringBuffer().append("Error reading object header: ").append(iOException).toString());
            }
            Object object = objectStreamClass.getObject(this);
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(classNotFoundException).toString());
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(classCastException).toString());
        }
    }

    private Object getClassOnly() throws StreamCorruptedException, OptionalDataException, InvalidClassException {
        try {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
            this.makeObjectReference(objectStreamClass);
            return objectStreamClass;
        }
        catch (InvalidClassException invalidClassException) {
            throw invalidClassException;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw streamCorruptedException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(classNotFoundException).toString());
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(iOException).toString());
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(classCastException).toString());
        }
    }

    private Object getStreamClass() throws StreamCorruptedException, InvalidClassException {
        try {
            Object object = defaultClassDesc.getClass(this);
            return object;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw streamCorruptedException;
        }
        catch (InvalidClassException invalidClassException) {
            throw invalidClassException;
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting class: ").append(iOException).toString());
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException(new StringBuffer().append("error getting class: ").append(classCastException).toString());
        }
    }

    private Object getArray() throws StreamCorruptedException, InvalidClassException {
        try {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)this.readObject();
            Object object = objectStreamClass.getArray(this);
            return object;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw streamCorruptedException;
        }
        catch (InvalidClassException invalidClassException) {
            throw invalidClassException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting array: ").append(classNotFoundException).toString());
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting array: ").append(iOException).toString());
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            throw new StreamCorruptedException(new StringBuffer().append("error getting array: ").append(classCastException).toString());
        }
    }

    private /* synthetic */ void Block$() {
        this.objectReferences = new ArrayList();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class GetField {
        public abstract boolean defaulted(String var1) throws IOException, IllegalArgumentException;

        public abstract boolean get(String var1, boolean var2) throws IOException, IllegalArgumentException;

        public abstract byte get(String var1, byte var2) throws IOException, IllegalArgumentException;

        public abstract char get(String var1, char var2) throws IOException, IllegalArgumentException;

        public abstract short get(String var1, short var2) throws IOException, IllegalArgumentException;

        public abstract int get(String var1, int var2) throws IOException, IllegalArgumentException;

        public abstract float get(String var1, float var2) throws IOException, IllegalArgumentException;

        public abstract long get(String var1, long var2) throws IOException, IllegalArgumentException;

        public abstract double get(String var1, double var2) throws IOException, IllegalArgumentException;

        public abstract Object get(String var1, Object var2) throws IOException, IllegalArgumentException;

        public abstract ObjectStreamClass getObjectStreamClass();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BlockDataInputStream
    extends FilterInputStream {
        private final byte[] buffer;
        private int pos;
        private int len;
        private boolean buffering;
        private int leftinblock;

        BlockDataInputStream(InputStream inputStream) {
            super(inputStream);
            this.Block$();
        }

        boolean enableBuffering(boolean bl) {
            boolean bl2 = this.buffering;
            if (bl != bl2) {
                if (this.buffering) {
                    this.len = 0;
                    this.pos = 0;
                }
                this.buffering = bl;
            }
            return bl2;
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (!this.buffering) {
                return this.in.read(byArray, n, n2);
            }
            int n3 = 0;
            while (n3 < n2) {
                byArray[n + n3] = (byte)this.read();
                ++n3;
            }
            return n2;
        }

        @Override
        public int read() throws IOException {
            if (!this.buffering) {
                int n = this.in.read();
                return n;
            }
            if (this.pos < this.len) {
                return this.buffer[this.pos++] & 0xFF;
            }
            if (this.leftinblock > 0) {
                int n = this.buffer.length;
                if (n > this.leftinblock) {
                    n = this.leftinblock;
                }
                this.len = this.in.read(this.buffer, 0, n);
                if (this.len != n) {
                    throw new StreamCorruptedException(new StringBuffer().append("bad blockdata size, read ").append(this.len).append(" expected ").append(n).toString());
                }
                this.pos = 1;
                this.leftinblock -= this.len;
                return this.buffer[0] & 0xFF;
            }
            int n = this.in.read();
            switch (n) {
                case 119: {
                    this.leftinblock = this.in.read();
                    return this.read();
                }
                case 122: {
                    int n2 = 0;
                    int n3 = 24;
                    while (n3 >= 0) {
                        n = this.in.read();
                        if (n == -1) {
                            throw new StreamCorruptedException("reached eof while reading block size");
                        }
                        n2 |= n << n3;
                        n3 -= 8;
                    }
                    this.leftinblock = n2;
                    return this.read();
                }
            }
            throw new StreamCorruptedException(new StringBuffer().append("expected blockdata start marker, but got : 0x").append(Integer.toHexString(n)).toString());
        }

        private /* synthetic */ void Block$() {
            this.buffer = new byte[255];
        }
    }
}

