/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Hashtable;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamClass
implements Serializable {
    public static ObjectStreamField[] NO_FIELDS = new ObjectStreamField[0];
    private static final boolean DOTRACE = false;
    private static final long serialVersionUID = -6120832682080437368L;
    private static final Hashtable streamClasses = new Hashtable();
    private Class clazz;
    private int method;
    private long clazz_serialVersionUID;
    private ObjectStreamClass superstream;
    private ObjectStreamField[] serializableFields;
    private ObjectStreamField[] readableFields;
    private ConcretePutField userPutField;
    private ConcreteGetField userGetField;

    private ObjectStreamClass(Class clazz, int n) {
        this.Block$();
        if (clazz == null) {
            throw new NullPointerException();
        }
        this.clazz = clazz;
        this.method = n;
        this.clazz_serialVersionUID = ObjectStreamClass.getSerialVersionUID0(clazz);
        this.superstream = ObjectStreamClass.lookup(clazz.getSuperclass());
        this.serializableFields = ObjectStreamClass.findSerializableFields0(this.clazz);
    }

    ObjectStreamClass() {
        this.Block$();
        this.clazz = Class.forName("java.io.ObjectStreamClass");
        this.method = 3;
        this.clazz_serialVersionUID = -6120832682080437368L;
        this.superstream = null;
        this.serializableFields = NO_FIELDS;
    }

    public Class forClass() {
        return this.clazz;
    }

    public String getName() {
        return this.clazz.getName();
    }

    public String toString() {
        return new StringBuffer().append(this.getName()).append(": static final long serialVersionUID = ").append(Long.toString(this.getSerialVersionUID())).append("L;").toString();
    }

    public static ObjectStreamClass lookup(Class clazz) {
        int n;
        if (clazz == null) {
            return null;
        }
        ObjectStreamClass objectStreamClass = (ObjectStreamClass)streamClasses.get(clazz);
        if (objectStreamClass != null) {
            return objectStreamClass;
        }
        if (Class.forName("java.io.Externalizable").isAssignableFrom(clazz)) {
            n = 6;
        } else if (Class.forName("java.io.Serializable").isAssignableFrom(clazz)) {
            n = 2;
            if (ObjectStreamClass.hasWriteObject(clazz)) {
                n |= 1;
            }
        } else {
            return null;
        }
        objectStreamClass = new ObjectStreamClass(clazz, n);
        streamClasses.put(clazz, objectStreamClass);
        return objectStreamClass;
    }

    public ObjectStreamField getField(String string) {
        int n = 0;
        while (n < this.serializableFields.length) {
            if (string.equals(this.serializableFields[n].getName())) {
                return this.serializableFields[n];
            }
            ++n;
        }
        return null;
    }

    public ObjectStreamField[] getFields() {
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[this.serializableFields.length];
        System.arraycopy(this.serializableFields, 0, objectStreamFieldArray, 0, this.serializableFields.length);
        return objectStreamFieldArray;
    }

    public long getSerialVersionUID() {
        if (this.clazz_serialVersionUID == 0L) {
            this.clazz_serialVersionUID = ObjectStreamClass.getSerialVersionUID0(this.clazz);
        }
        return this.clazz_serialVersionUID;
    }

    ObjectOutputStream.PutField putFields() throws IOException {
        if (this.userPutField == null) {
            this.userPutField = new ConcretePutField(this.serializableFields);
        }
        return this.userPutField;
    }

    void writeFields(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        if (this.userPutField == null) {
            throw new NotActiveException("no current PutField object (use putFields())");
        }
        this.userPutField.writeTo(objectOutputStream);
    }

    ObjectInputStream.GetField readFields(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        if (this.userGetField == null) {
            this.userGetField = new ConcreteGetField(this, objectInputStream);
        }
        return this.userGetField;
    }

    Object getObject(ObjectInputStream objectInputStream) throws StreamCorruptedException, InvalidClassException, OptionalDataException {
        Object object = this.allocateNewObject();
        objectInputStream.makeObjectReference(object);
        this.getObjectWithoutSuper(object, objectInputStream);
        return object;
    }

    private void getObjectWithoutSuper(Object object, ObjectInputStream objectInputStream) throws StreamCorruptedException, InvalidClassException, OptionalDataException {
        if (this.superstream != null) {
            this.superstream.getObjectWithoutSuper(object, objectInputStream);
        }
        try {
            if ((this.method & 4) != 0) {
                try {
                    ((Externalizable)object).readExternal(objectInputStream);
                    return;
                }
                catch (IOException iOException) {
                    throw new StreamCorruptedException(new StringBuffer().append("error in readExternal").append(iOException).toString());
                }
            }
            if ((this.method & 1) != 0) {
                boolean bl = objectInputStream.enableBuffering(true);
                this.userGetField = null;
                this.invokeObjectReader0(object, objectInputStream);
                objectInputStream.enableBuffering(bl);
                this.getEndOfDataBlock(objectInputStream);
                return;
            }
            if ((this.method & 2) != 0) {
                this.defaultReadObject(object, objectInputStream);
                return;
            }
            throw new StreamCorruptedException("unknown method type");
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw streamCorruptedException;
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(classCastException).toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(classNotFoundException).toString());
        }
    }

    private void getEndOfDataBlock(ObjectInputStream objectInputStream) throws StreamCorruptedException {
        byte by = 0;
        try {
            by = objectInputStream.readByte();
        }
        catch (IOException iOException) {
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(new StringBuffer().append("failed to read endblockdata: ").append(iOException).toString());
            streamCorruptedException.initCause(iOException);
            throw streamCorruptedException;
        }
        if (by != 120) {
            throw new StreamCorruptedException("failed to read endblockdata: no marker found");
        }
    }

    Object getClass(ObjectInputStream objectInputStream) throws StreamCorruptedException, InvalidClassException, OptionalDataException {
        try {
            Object object = this.allocateNewObject();
            objectInputStream.makeObjectReference(object);
            this.userGetField = null;
            this.invokeObjectReader0(object, objectInputStream);
            this.getEndOfDataBlock(objectInputStream);
            ((ObjectStreamClass)object).superstream = (ObjectStreamClass)objectInputStream.readObject();
            return object;
        }
        catch (InvalidClassException invalidClassException) {
            throw invalidClassException;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw streamCorruptedException;
        }
        catch (IOException iOException) {
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(iOException).toString());
            streamCorruptedException.initCause(iOException);
            throw streamCorruptedException;
        }
        catch (ClassNotFoundException classNotFoundException) {
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException(new StringBuffer().append("error getting object: ").append(classNotFoundException).toString());
            streamCorruptedException.initCause(classNotFoundException);
            throw streamCorruptedException;
        }
    }

    Object getArray(ObjectInputStream objectInputStream) throws StreamCorruptedException, InvalidClassException {
        try {
            Class clazz = this.clazz.getComponentType();
            int n = objectInputStream.readInt();
            Object object = this.allocateNewArray(n);
            objectInputStream.makeObjectReference(object);
            if (clazz == Character.TYPE) {
                char[] cArray = (char[])object;
                int n2 = 0;
                while (n2 < n) {
                    cArray[n2] = objectInputStream.readChar();
                    ++n2;
                }
            } else if (clazz == Short.TYPE) {
                short[] sArray = (short[])object;
                int n3 = 0;
                while (n3 < n) {
                    sArray[n3] = objectInputStream.readShort();
                    ++n3;
                }
            } else if (clazz == Integer.TYPE) {
                int[] nArray = (int[])object;
                int n4 = 0;
                while (n4 < n) {
                    nArray[n4] = objectInputStream.readInt();
                    ++n4;
                }
            } else if (clazz == Boolean.TYPE) {
                boolean[] blArray = (boolean[])object;
                int n5 = 0;
                while (n5 < n) {
                    blArray[n5] = objectInputStream.readBoolean();
                    ++n5;
                }
            } else if (clazz == Long.TYPE) {
                long[] lArray = (long[])object;
                int n6 = 0;
                while (n6 < n) {
                    lArray[n6] = objectInputStream.readLong();
                    ++n6;
                }
            } else if (clazz == Double.TYPE) {
                double[] dArray = (double[])object;
                int n7 = 0;
                while (n7 < n) {
                    dArray[n7] = objectInputStream.readDouble();
                    ++n7;
                }
            } else if (clazz == Float.TYPE) {
                float[] fArray = (float[])object;
                int n8 = 0;
                while (n8 < n) {
                    fArray[n8] = objectInputStream.readFloat();
                    ++n8;
                }
            } else if (clazz == Byte.TYPE) {
                byte[] byArray = (byte[])object;
                int n9 = 0;
                while (n9 < n) {
                    byArray[n9] = objectInputStream.readByte();
                    ++n9;
                }
            } else {
                Object[] objectArray = (Object[])object;
                int n10 = 0;
                while (n10 < n) {
                    objectArray[n10] = objectInputStream.readObject();
                    ++n10;
                }
            }
            return object;
        }
        catch (ClassCastException classCastException) {
            throw new StreamCorruptedException(new StringBuffer().append("bad array: ").append(classCastException).toString());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StreamCorruptedException(new StringBuffer().append("bad array: ").append(classNotFoundException).toString());
        }
        catch (InvalidClassException invalidClassException) {
            throw invalidClassException;
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw streamCorruptedException;
        }
        catch (IOException iOException) {
            throw new StreamCorruptedException(new StringBuffer().append("bad array: ").append(iOException).toString());
        }
    }

    void putObject(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.makeObjectReference(object);
        this.putObjectWithoutSuper(object, objectOutputStream);
    }

    private void putObjectWithoutSuper(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        if (this.superstream != null) {
            this.superstream.putObjectWithoutSuper(object, objectOutputStream);
        }
        if ((this.method & 4) != 0) {
            ((Externalizable)object).writeExternal(objectOutputStream);
            return;
        }
        if ((this.method & 1) != 0) {
            boolean bl = objectOutputStream.enableBuffering(true);
            this.userPutField = null;
            this.invokeObjectWriter0(object, objectOutputStream);
            objectOutputStream.enableBuffering(bl);
            objectOutputStream.writeByte(120);
            return;
        }
        if ((this.method & 2) != 0) {
            this.defaultWriteObject(object, objectOutputStream);
            return;
        }
        throw new StreamCorruptedException("unknown method type");
    }

    void putClass(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.makeObjectReference(object);
        this.userPutField = null;
        this.invokeObjectWriter0(object, objectOutputStream);
        objectOutputStream.annotateClassInternal(((ObjectStreamClass)object).clazz);
        objectOutputStream.writeByte(120);
    }

    void putArray(Object object, ObjectOutputStream objectOutputStream) throws IOException {
        Class clazz = object.getClass().getComponentType();
        objectOutputStream.makeObjectReference(object);
        if (clazz == Character.TYPE) {
            char[] cArray = (char[])object;
            int n = cArray.length;
            objectOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                objectOutputStream.writeChar(cArray[n2]);
                ++n2;
            }
            return;
        }
        if (clazz == Byte.TYPE) {
            byte[] byArray = (byte[])object;
            int n = byArray.length;
            objectOutputStream.writeInt(n);
            int n3 = 0;
            while (n3 < n) {
                objectOutputStream.writeByte(byArray[n3]);
                ++n3;
            }
            return;
        }
        if (clazz == Short.TYPE) {
            short[] sArray = (short[])object;
            int n = sArray.length;
            objectOutputStream.writeInt(n);
            int n4 = 0;
            while (n4 < n) {
                objectOutputStream.writeShort(sArray[n4]);
                ++n4;
            }
            return;
        }
        if (clazz == Integer.TYPE) {
            int[] nArray = (int[])object;
            int n = nArray.length;
            objectOutputStream.writeInt(n);
            int n5 = 0;
            while (n5 < n) {
                objectOutputStream.writeInt(nArray[n5]);
                ++n5;
            }
            return;
        }
        if (clazz == Boolean.TYPE) {
            boolean[] blArray = (boolean[])object;
            int n = blArray.length;
            objectOutputStream.writeInt(n);
            int n6 = 0;
            while (n6 < n) {
                objectOutputStream.writeBoolean(blArray[n6]);
                ++n6;
            }
            return;
        }
        if (clazz == Long.TYPE) {
            long[] lArray = (long[])object;
            int n = lArray.length;
            objectOutputStream.writeInt(n);
            int n7 = 0;
            while (n7 < n) {
                objectOutputStream.writeLong(lArray[n7]);
                ++n7;
            }
            return;
        }
        if (clazz == Double.TYPE) {
            double[] dArray = (double[])object;
            int n = dArray.length;
            objectOutputStream.writeInt(n);
            int n8 = 0;
            while (n8 < n) {
                objectOutputStream.writeDouble(dArray[n8]);
                ++n8;
            }
            return;
        }
        if (clazz == Float.TYPE) {
            float[] fArray = (float[])object;
            int n = fArray.length;
            objectOutputStream.writeInt(n);
            int n9 = 0;
            while (n9 < n) {
                objectOutputStream.writeFloat(fArray[n9]);
                ++n9;
            }
            return;
        }
        Object[] objectArray = (Object[])object;
        int n = objectArray.length;
        objectOutputStream.writeInt(n);
        int n10 = 0;
        while (n10 < n) {
            objectOutputStream.writeObject(objectArray[n10]);
            ++n10;
        }
    }

    void defaultReadObject(Object object, ObjectInputStream objectInputStream) {
        ObjectStreamClass.inputClassFields0(this.clazz, this.readableFields, object, objectInputStream);
    }

    void defaultWriteObject(Object object, ObjectOutputStream objectOutputStream) {
        ObjectStreamClass.outputClassFields0(this.clazz, this.serializableFields, object, objectOutputStream);
    }

    void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        this.clazz_serialVersionUID = objectInputStream.readLong();
        this.method = objectInputStream.readUnsignedByte();
        this.clazz = objectInputStream.resolveClassInternal(string);
        this.serializableFields = ObjectStreamClass.findSerializableFields0(this.clazz);
        int n = objectInputStream.readShort();
        InStreamTypeDescriptor[] inStreamTypeDescriptorArray = new InStreamTypeDescriptor[n];
        int n2 = 0;
        while (n2 < n) {
            inStreamTypeDescriptorArray[n2] = new InStreamTypeDescriptor();
            inStreamTypeDescriptorArray[n2].typeCode = (byte)objectInputStream.readUnsignedByte();
            inStreamTypeDescriptorArray[n2].fieldName = objectInputStream.readUTF();
            if (inStreamTypeDescriptorArray[n2].typeCode == 76 || inStreamTypeDescriptorArray[n2].typeCode == 91) {
                try {
                    inStreamTypeDescriptorArray[n2].typeName = ((String)objectInputStream.readObject()).intern();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new StreamCorruptedException("bad type");
                }
            } else {
                inStreamTypeDescriptorArray[n2].typeName = null;
            }
            ++n2;
        }
        long l = ObjectStreamClass.getSerialVersionUID0(this.clazz);
        if (this.clazz_serialVersionUID != l) {
            throw new InvalidClassException(new StringBuffer().append("mismatched serial version UIDs: expected ").append(this.clazz_serialVersionUID).append(" but local class `").append(this.clazz.getName()).append("' has UID ").append(l).toString());
        }
        this.resolveVMFieldsSerialFields(inStreamTypeDescriptorArray);
        this.clazz = objectInputStream.resolveClass(this);
    }

    private void resolveVMFieldsSerialFields(InStreamTypeDescriptor[] inStreamTypeDescriptorArray) {
        this.readableFields = new ObjectStreamField[inStreamTypeDescriptorArray.length];
        int n = 0;
        while (n < inStreamTypeDescriptorArray.length) {
            InStreamTypeDescriptor inStreamTypeDescriptor = inStreamTypeDescriptorArray[n];
            int n2 = 0;
            while (n2 < this.serializableFields.length && this.readableFields[n] == null) {
                ObjectStreamField objectStreamField = this.serializableFields[n2];
                this.readableFields[n] = ObjectStreamClass.compareFields(inStreamTypeDescriptor, objectStreamField);
                ++n2;
            }
            if (this.readableFields[n] == null) {
                this.readableFields[n] = new ObjectStreamField(inStreamTypeDescriptor.fieldName, inStreamTypeDescriptor.typeCode, inStreamTypeDescriptor.typeName);
                this.readableFields[n].setIgnored();
            }
            ++n;
        }
    }

    private static ObjectStreamField compareFields(InStreamTypeDescriptor inStreamTypeDescriptor, ObjectStreamField objectStreamField) {
        if (inStreamTypeDescriptor.fieldName.equals(objectStreamField.getName())) {
            String string = inStreamTypeDescriptor.typeName;
            String string2 = objectStreamField.getTypeString();
            boolean bl = false;
            if (string == null && string2 == null && inStreamTypeDescriptor.typeCode == objectStreamField.getTypeCode()) {
                bl = true;
            } else if (string != null && string2 != null && string.equals(string2)) {
                bl = true;
            }
            if (bl) {
                return objectStreamField;
            }
            ObjectStreamField objectStreamField2 = new ObjectStreamField(inStreamTypeDescriptor.fieldName, inStreamTypeDescriptor.typeCode, inStreamTypeDescriptor.typeName);
            objectStreamField2.setMismatch(true);
            return objectStreamField2;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeUTF(this.getName());
        objectOutputStream.writeLong(this.clazz_serialVersionUID);
        objectOutputStream.writeByte(this.method);
        objectOutputStream.writeShort(this.serializableFields.length);
        int n = 0;
        while (n < this.serializableFields.length) {
            ObjectStreamField objectStreamField = this.serializableFields[n];
            objectOutputStream.writeByte((byte)objectStreamField.getTypeCode());
            objectOutputStream.writeUTF(objectStreamField.getName());
            String string = objectStreamField.getTypeString();
            if (string != null) {
                objectOutputStream.writeObject(string);
            }
            ++n;
        }
    }

    private static boolean hasWriteObject(Class clazz) {
        return ObjectStreamClass.hasWriteObject0(clazz);
    }

    private native Object allocateNewObject();

    private native Object allocateNewArray(int var1);

    private static native boolean hasWriteObject0(Class var0);

    private native boolean invokeObjectReader0(Object var1, ObjectInputStream var2);

    private native boolean invokeObjectWriter0(Object var1, ObjectOutputStream var2);

    private static native void init0();

    private static native long getSerialVersionUID0(Class var0);

    private static native ObjectStreamField[] findSerializableFields0(Class var0);

    private static native void outputClassFields0(Class var0, ObjectStreamField[] var1, Object var2, ObjectOutputStream var3);

    private static native void inputClassFields0(Class var0, ObjectStreamField[] var1, Object var2, ObjectInputStream var3);

    static {
        ObjectStreamClass.init0();
    }

    private /* synthetic */ void Block$() {
        this.readableFields = null;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InStreamTypeDescriptor {
        String fieldName;
        String typeName;
        byte typeCode;

        private InStreamTypeDescriptor() {
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConcretePutField
    extends ObjectOutputStream.PutField {
        private final ObjectStreamField[] fields;
        private final Value[] values;

        ConcretePutField(ObjectStreamField[] objectStreamFieldArray) {
            this.fields = objectStreamFieldArray;
            this.values = new Value[objectStreamFieldArray.length];
        }

        private int findIndex(String string) throws IllegalArgumentException {
            if (string == null) {
                throw new NullPointerException("null field name");
            }
            int n = 0;
            while (n < this.fields.length) {
                if (this.fields[n].getName().equals(string)) {
                    return n;
                }
                ++n;
            }
            throw new IllegalArgumentException(new StringBuffer().append("Field `").append(string).append("' is not a serializable field.").toString());
        }

        private static void requireType(ObjectStreamField objectStreamField, Class clazz) throws IllegalArgumentException {
            if (!objectStreamField.getType().equals(clazz)) {
                throw new IllegalArgumentException(new StringBuffer().append("Field `").append(objectStreamField.getName()).append("' has type ").append(clazz.getName()).toString());
            }
        }

        @Override
        public void put(String string, boolean bl) {
            int n = this.findIndex(string);
            ConcretePutField.requireType(this.fields[n], Boolean.TYPE);
            this.values[n] = new 9(this, bl);
        }

        @Override
        public void put(String string, byte by) {
            int n = this.findIndex(string);
            ConcretePutField.requireType(this.fields[n], Byte.TYPE);
            this.values[n] = new 8(this, by);
        }

        @Override
        public void put(String string, char c) {
            int n = this.findIndex(string);
            ConcretePutField.requireType(this.fields[n], Character.TYPE);
            this.values[n] = new 7(this, c);
        }

        @Override
        public void put(String string, short s) {
            int n = this.findIndex(string);
            ConcretePutField.requireType(this.fields[n], Short.TYPE);
            this.values[n] = new 6(this, s);
        }

        @Override
        public void put(String string, int n) {
            int n2 = this.findIndex(string);
            ConcretePutField.requireType(this.fields[n2], Integer.TYPE);
            this.values[n2] = new 5(this, n);
        }

        @Override
        public void put(String string, long l) {
            int n = this.findIndex(string);
            ConcretePutField.requireType(this.fields[n], Long.TYPE);
            this.values[n] = new 4(this, l);
        }

        @Override
        public void put(String string, float f) {
            int n = this.findIndex(string);
            ConcretePutField.requireType(this.fields[n], Float.TYPE);
            this.values[n] = new 3(this, f);
        }

        @Override
        public void put(String string, double d) {
            int n = this.findIndex(string);
            ConcretePutField.requireType(this.fields[n], Double.TYPE);
            this.values[n] = new 2(this, d);
        }

        @Override
        public void put(String string, Object object) {
            int n = this.findIndex(string);
            if (this.fields[n].getType().isPrimitive()) {
                throw new IllegalArgumentException(new StringBuffer().append("Field `").append(string).append("' has primitive type ").append(this.fields[n].getType().getName()).toString());
            }
            this.values[n] = new 1(this, object);
        }

        @Override
        public void write(ObjectOutput objectOutput) throws IOException {
            throw new NotImplemented("ObjectOutputStream.PutField.write() -- its deprecated anyway.");
        }

        void writeTo(ObjectOutputStream objectOutputStream) throws IOException {
            int n = 0;
            while (n < this.values.length) {
                if (this.values[n] != null) {
                    this.values[n].put(objectOutputStream);
                } else {
                    switch (this.fields[n].getTypeCode()) {
                        case 'L': 
                        case '[': {
                            objectOutputStream.writeObject(null);
                            break;
                        }
                        case 'I': {
                            objectOutputStream.writeInt(0);
                            break;
                        }
                        case 'J': {
                            objectOutputStream.writeLong(0L);
                            break;
                        }
                        case 'Z': {
                            objectOutputStream.writeBoolean(false);
                            break;
                        }
                        case 'B': {
                            objectOutputStream.writeByte(0);
                            break;
                        }
                        case 'S': {
                            objectOutputStream.writeShort(0);
                            break;
                        }
                        case 'C': {
                            objectOutputStream.writeChar(0);
                            break;
                        }
                        case 'F': {
                            objectOutputStream.writeFloat(0.0f);
                            break;
                        }
                        case 'D': {
                            objectOutputStream.writeDouble(0.0);
                            break;
                        }
                        default: {
                            throw new InternalError(new StringBuffer().append("Illegal typecode in ").append(this.fields[n]).toString());
                        }
                    }
                }
                ++n;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static abstract class Value {
            abstract void put(ObjectOutputStream var1) throws IOException;

            private Value() {
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 1
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ Object var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeObject(this.var$fvalue);
            }

            public 1() {
                this.this$0 = var1_1;
                this.var$fvalue = var2_2;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 2
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ double var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeDouble(this.var$fvalue);
            }

            public 2() {
                this.this$0 = var1_1;
                this.var$fvalue = d;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 3
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ float var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeFloat(this.var$fvalue);
            }

            public 3() {
                this.this$0 = var1_1;
                this.var$fvalue = f;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 4
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ long var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeLong(this.var$fvalue);
            }

            public 4() {
                this.this$0 = var1_1;
                this.var$fvalue = l;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 5
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ int var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeInt(this.var$fvalue);
            }

            public 5() {
                this.this$0 = var1_1;
                this.var$fvalue = n;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 6
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ short var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeShort(this.var$fvalue);
            }

            public 6() {
                this.this$0 = var1_1;
                this.var$fvalue = (short)n;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 7
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ char var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeChar(this.var$fvalue);
            }

            public 7() {
                this.this$0 = var1_1;
                this.var$fvalue = (char)n;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 8
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ byte var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeByte(this.var$fvalue);
            }

            public 8() {
                this.this$0 = var1_1;
                this.var$fvalue = (byte)n;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 9
        extends Value {
            private final /* synthetic */ ConcretePutField this$0;
            private final /* synthetic */ boolean var$fvalue;

            @Override
            void put(ObjectOutputStream objectOutputStream) throws IOException {
                objectOutputStream.writeBoolean(this.var$fvalue);
            }

            public 9() {
                this.this$0 = var1_1;
                this.var$fvalue = n;
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConcreteGetField
    extends ObjectInputStream.GetField {
        private final ObjectStreamClass objectStreamClass;
        private final Field[] loadedFields;
        private final ObjectStreamField[] defaultedFields;

        ConcreteGetField(ObjectStreamClass objectStreamClass, ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            int n;
            Object object;
            this.objectStreamClass = objectStreamClass;
            this.loadedFields = new Field[objectStreamClass.readableFields.length];
            int n2 = 0;
            while (n2 < this.loadedFields.length) {
                ObjectStreamField objectStreamField = objectStreamClass.readableFields[n2];
                object = objectStreamField.getName();
                n = objectStreamField.getTypeCode();
                this.loadedFields[n2] = ConcreteGetField.readField(objectInputStream, (String)object, (char)n);
                ++n2;
            }
            ArrayList arrayList = new ArrayList();
            int n3 = 0;
            while (n3 < objectStreamClass.serializableFields.length) {
                object = objectStreamClass.serializableFields[n3];
                n = this.findLoadedField(((ObjectStreamField)object).getName());
                if (n == -1) {
                    arrayList.add(object);
                }
                ++n3;
            }
            this.defaultedFields = (ObjectStreamField[])arrayList.toArray(new ObjectStreamField[0]);
        }

        private int findLoadedField(String string) {
            int n = 0;
            while (n < this.loadedFields.length) {
                if (this.loadedFields[n].fname.equals(string)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private int findDefaultedField(String string) {
            int n = 0;
            while (n < this.defaultedFields.length) {
                if (this.defaultedFields[n].getName().equals(string)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }

        private static Field readField(ObjectInputStream objectInputStream, String string, char c) throws IOException, ClassNotFoundException {
            if (c == '[' || c == 'L') {
                Object object = objectInputStream.readObject();
                return new 1(string, object);
            }
            switch (c) {
                case 'I': {
                    int n = objectInputStream.readInt();
                    return new 2(string, n);
                }
                case 'J': {
                    long l = objectInputStream.readLong();
                    return new 3(string, l);
                }
                case 'Z': {
                    boolean bl = objectInputStream.readBoolean();
                    return new 4(string, bl);
                }
                case 'B': {
                    byte by = objectInputStream.readByte();
                    return new 5(string, by);
                }
                case 'C': {
                    char c2 = objectInputStream.readChar();
                    return new 6(string, c2);
                }
                case 'S': {
                    short s = objectInputStream.readShort();
                    return new 7(string, s);
                }
                case 'F': {
                    float f = objectInputStream.readFloat();
                    return new 8(string, f);
                }
                case 'D': {
                    double d = objectInputStream.readDouble();
                    return new 9(string, d);
                }
            }
            return new Field(string);
        }

        @Override
        public boolean defaulted(String string) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return false;
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                return true;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No such field `").append(string).append("'").toString());
        }

        private static void requireFieldCode(ObjectStreamField objectStreamField, char c, String string) {
            if (objectStreamField.getTypeCode() != c) {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(objectStreamField.getName()).append("' is not a ").append(string).toString());
            }
        }

        @Override
        public boolean get(String string, boolean bl) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return this.loadedFields[n].getBool();
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n], 'Z', "boolean");
                return bl;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public byte get(String string, byte by) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return this.loadedFields[n].getByte();
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n], 'B', "byte");
                return by;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public char get(String string, char c) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return this.loadedFields[n].getChar();
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n], 'C', "char");
                return c;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public short get(String string, short s) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return this.loadedFields[n].getShort();
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n], 'S', "short");
                return s;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public int get(String string, int n) throws IOException, IllegalArgumentException {
            int n2 = this.findLoadedField(string);
            if (n2 != -1) {
                return this.loadedFields[n2].getInt();
            }
            n2 = this.findDefaultedField(string);
            if (n2 != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n2], 'I', "int");
                return n;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public float get(String string, float f) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return this.loadedFields[n].getFloat();
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n], 'F', "float");
                return f;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public long get(String string, long l) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return this.loadedFields[n].getLong();
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n], 'J', "long");
                return l;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public double get(String string, double d) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return this.loadedFields[n].getDouble();
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n], 'D', "double");
                return d;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public Object get(String string, Object object) throws IOException, IllegalArgumentException {
            int n = this.findLoadedField(string);
            if (n != -1) {
                return this.loadedFields[n].getObject();
            }
            n = this.findDefaultedField(string);
            if (n != -1) {
                ConcreteGetField.requireFieldCode(this.defaultedFields[n], 'L', "object reference");
                return object;
            }
            throw new IllegalArgumentException(new StringBuffer().append("No field named `").append(string).append("'").toString());
        }

        @Override
        public ObjectStreamClass getObjectStreamClass() {
            return this.objectStreamClass;
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class Field {
            final String fname;

            Field(String string) {
                this.fname = string;
            }

            boolean getBool() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not a boolean").toString());
            }

            byte getByte() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not a byte").toString());
            }

            char getChar() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not a char").toString());
            }

            short getShort() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not a short").toString());
            }

            int getInt() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not a int").toString());
            }

            long getLong() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not a long").toString());
            }

            float getFloat() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not a float").toString());
            }

            double getDouble() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not a double").toString());
            }

            Object getObject() {
                throw new IllegalArgumentException(new StringBuffer().append("Field '").append(this.fname).append("' is not an object reference").toString());
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 1
        extends Field {
            private final /* synthetic */ Object var$val;

            @Override
            Object getObject() {
                return this.var$val;
            }

            public 1(String string) {
                super(var1_1);
                this.var$val = string;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 2
        extends Field {
            private final /* synthetic */ int var$ival;

            @Override
            int getInt() {
                return this.var$ival;
            }

            /*
             * WARNING - Possible parameter corruption
             */
            public 2(String string) {
                super((String)n);
                this.var$ival = (int)string;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 3
        extends Field {
            private final /* synthetic */ long var$jval;

            @Override
            long getLong() {
                return this.var$jval;
            }

            /*
             * WARNING - Possible parameter corruption
             * WARNING - void declaration
             */
            public 3(String string) {
                super((String)l);
                void var2_-1;
                this.var$jval = var2_-1;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 4
        extends Field {
            private final /* synthetic */ boolean var$zval;

            boolean getBoolean() {
                return this.var$zval;
            }

            /*
             * WARNING - Possible parameter corruption
             */
            public 4(String string) {
                super((String)n);
                this.var$zval = string;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 5
        extends Field {
            private final /* synthetic */ byte var$bval;

            @Override
            byte getByte() {
                return this.var$bval;
            }

            /*
             * WARNING - Possible parameter corruption
             */
            public 5(String string) {
                super((String)n);
                this.var$bval = (byte)string;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 6
        extends Field {
            private final /* synthetic */ char var$cval;

            @Override
            char getChar() {
                return this.var$cval;
            }

            /*
             * WARNING - Possible parameter corruption
             */
            public 6(String string) {
                super((String)n);
                this.var$cval = (char)string;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 7
        extends Field {
            private final /* synthetic */ short var$sval;

            @Override
            short getShort() {
                return this.var$sval;
            }

            /*
             * WARNING - Possible parameter corruption
             */
            public 7(String string) {
                super((String)n);
                this.var$sval = (short)string;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 8
        extends Field {
            private final /* synthetic */ float var$fval;

            @Override
            float getFloat() {
                return this.var$fval;
            }

            /*
             * WARNING - Possible parameter corruption
             */
            public 8(String string) {
                super((String)f);
                this.var$fval = (float)string;
            }
        }

        /*
         * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class 9
        extends Field {
            private final /* synthetic */ double var$dval;

            @Override
            double getDouble() {
                return this.var$dval;
            }

            /*
             * WARNING - Possible parameter corruption
             * WARNING - void declaration
             */
            public 9(String string) {
                super((String)d);
                void var2_-1;
                this.var$dval = var2_-1;
            }
        }
    }
}

