/*
 * Decompiled with CFR 0.152.
 */
package java.io;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamField
implements Comparable {
    private final Class type;
    private final String name;
    private final boolean unshared;
    private String typeStr;
    private final byte typeCode;
    int offset;
    boolean typeMismatch;

    public ObjectStreamField(String string, Class clazz) {
        this(string, clazz, false);
    }

    public ObjectStreamField(String string, Class clazz, boolean bl) {
        if (string == null) {
            throw new NullPointerException();
        }
        this.type = clazz;
        this.name = string;
        this.unshared = bl;
        this.offset = -1;
        this.typeMismatch = true;
        this.typeCode = this.type.isArray() ? (byte)91 : (this.type.isPrimitive() ? (this.type == Boolean.TYPE ? (byte)90 : (this.type == Long.TYPE ? (byte)74 : (this.type == Integer.TYPE ? (byte)73 : (this.type == Short.TYPE ? (byte)83 : (this.type == Byte.TYPE ? (byte)66 : (this.type == Character.TYPE ? (byte)67 : (this.type == Float.TYPE ? (byte)70 : (this.type == Double.TYPE ? (byte)68 : (byte)86)))))))) : (byte)76);
        this.typeStr = null;
    }

    ObjectStreamField(String string, byte by, String string2) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (by == 0) {
            throw new InternalError("Illegal typeCode (0)");
        }
        this.name = string;
        this.type = null;
        this.typeStr = string2;
        this.typeCode = by;
        this.typeMismatch = false;
        this.offset = -1;
        this.unshared = false;
    }

    public String getName() {
        return this.name;
    }

    void setMismatch(boolean bl) {
        this.typeMismatch = bl;
    }

    void setIgnored() {
        this.offset = -1;
    }

    public Class getType() {
        return this.type;
    }

    public char getTypeCode() {
        return (char)this.typeCode;
    }

    public String getTypeString() {
        if (this.type == null) {
            return this.typeStr;
        }
        if (this.type.isPrimitive()) {
            return null;
        }
        if (this.typeStr == null) {
            String string = this.type.isArray() ? this.type.getName() : new StringBuffer().append("L").append(this.type.getName()).append(";").toString();
            this.typeStr = string.replace('.', '/').intern();
        }
        return this.typeStr;
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    protected void setOffset(int n) {
        this.offset = n;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public int compareTo(Object object) {
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        if (objectStreamField.type.isPrimitive() && !this.type.isPrimitive()) {
            return 1;
        }
        if (this.type.isPrimitive()) {
            return -1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    public String toString() {
        return new StringBuffer().append(this.type.getName()).append(" ").append(this.getName()).append("; //").append(" @").append(this.offset).append(this.unshared ? ", unshared" : "").toString();
    }
}

