/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PipedOutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PipedInputStream
extends InputStream {
    PipedOutputStream src;
    protected static final int PIPE_SIZE = 512;
    protected byte[] buffer;
    protected int out;
    protected int in;
    private boolean closed;
    private boolean finished;

    public PipedInputStream() {
        this.Block$();
    }

    public PipedInputStream(PipedOutputStream pipedOutputStream) throws IOException {
        this.Block$();
        this.connect(pipedOutputStream);
    }

    @Override
    public int available() throws IOException {
        if (this.in >= this.out) {
            return this.in - this.out;
        }
        return 512 + this.out - this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.out = 0;
        this.in = 0;
        this.closed = true;
        PipedInputStream pipedInputStream = this;
        synchronized (pipedInputStream) {
            this.finished = true;
            this.notifyAll();
            return;
        }
    }

    public void connect(PipedOutputStream pipedOutputStream) throws IOException {
        if (this.src != null) {
            throw new IOException("already connected");
        }
        this.src = pipedOutputStream;
        if (pipedOutputStream.sink == null) {
            pipedOutputStream.connect(this);
        }
        this.closed = false;
        this.finished = false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("stream closed");
        }
        if (!this.finished || this.out != this.in) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            try {
                this.wait();
            }
            catch (InterruptedException var1_1) {
                // empty catch block
            }
            if (!this.finished || this.out != this.in) continue;
            return -1;
lbl12:
            // 2 sources

            ** while (this.out == this.in)
        }
lbl13:
        // 1 sources

        var1_2 = this.buffer[this.out];
        this.out = (this.out + 1) % 512;
        this.notifyAll();
        return var1_2 & 255;
    }

    @Override
    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, Math.min(n2, Math.max(1, this.available())));
    }

    protected synchronized void receive(int n) throws IOException {
        while (this.out == (this.in + 1) % 512) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.buffer[this.in] = (byte)n;
        this.in = (this.in + 1) % 512;
        this.notifyAll();
    }

    synchronized void receivedLast() {
        this.finished = true;
        this.notifyAll();
    }

    private /* synthetic */ void Block$() {
        this.src = null;
        this.buffer = new byte[512];
        this.closed = true;
        this.finished = true;
    }
}

