/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintStream
extends FilterOutputStream {
    private static final char[] newline = System.getProperty("line.separator").toCharArray();
    private final boolean autoFlush;
    private boolean error;

    public PrintStream(OutputStream outputStream) {
        super(outputStream);
        this.autoFlush = false;
        if (outputStream == null) {
            throw new NullPointerException();
        }
    }

    public PrintStream(OutputStream outputStream, boolean bl) {
        super(outputStream);
        this.autoFlush = bl;
        if (outputStream == null) {
            throw new NullPointerException();
        }
    }

    public boolean checkError() {
        this.flush();
        return this.error;
    }

    protected void setError() {
        this.error = true;
    }

    @Override
    public void close() {
        try {
            this.flush();
            this.out.close();
            return;
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.error = true;
            return;
        }
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
            return;
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
            return;
        }
        catch (IOException iOException) {
            this.error = true;
            return;
        }
    }

    public void print(Object object) {
        this.print(String.valueOf(object).getBytes());
    }

    public void print(String string) {
        this.print((string != null ? string : "null").getBytes());
    }

    public void print(boolean bl) {
        this.print(String.valueOf(bl).getBytes());
    }

    public void print(char c) {
        this.print(String.valueOf(c).getBytes());
    }

    public void print(char[] cArray) {
        this.print(String.valueOf(cArray).getBytes());
    }

    public void print(double d) {
        this.print(String.valueOf(d).getBytes());
    }

    public void print(float f) {
        this.print(String.valueOf(f).getBytes());
    }

    public void print(int n) {
        this.print(String.valueOf(n).getBytes());
    }

    public void print(long l) {
        this.print(String.valueOf(l).getBytes());
    }

    public void println() {
        this.print(newline);
        if (this.autoFlush) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(Object object) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(object);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(String string) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(string);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(boolean bl) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(bl);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char c) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(c);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(char[] cArray) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(cArray);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(double d) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(d);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(float f) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(f);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(int n) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(n);
            this.println();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void println(long l) {
        PrintStream printStream = this;
        synchronized (printStream) {
            this.print(l);
            this.println();
            return;
        }
    }

    @Override
    public void write(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.out.write(byArray, n, n2);
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.error = true;
        }
        if (this.autoFlush) {
            this.flush();
        }
    }

    @Override
    public void write(int n) {
        try {
            this.out.write(n);
        }
        catch (InterruptedIOException interruptedIOException) {
            Thread.currentThread().interrupt();
        }
        catch (IOException iOException) {
            this.error = true;
        }
        if (n == 10 && this.autoFlush) {
            this.flush();
        }
    }

    private void print(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
        if (this.autoFlush) {
            this.flush();
        }
    }
}

