/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Vector;
import kaffe.lang.PackageHelper;
import kaffe.lang.PrimordialClassLoader;
import kaffe.lang.ThreadStack;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Class
implements Serializable {
    private Class() {
    }

    public static Class forName(String string) throws ClassNotFoundException {
        return Class.forName(string, true, ThreadStack.getCallersClassLoader(false));
    }

    public static native Class forName(String var0, boolean var1, ClassLoader var2) throws ClassNotFoundException;

    private String fullResourceName(String string) {
        if (string.charAt(0) == '/') {
            return string;
        }
        String string2 = this.getName();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.lastIndexOf(46);
        if (n != -1) {
            stringBuffer.append(string2.substring(0, n + 1).replace('.', '/'));
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public ClassLoader getClassLoader() {
        return this.getClassLoader0();
    }

    private native ClassLoader getClassLoader0();

    public Class getDeclaringClass() {
        Class[] classArray = this.getClasses0(false);
        switch (classArray.length) {
            case 0: {
                return null;
            }
            case 1: {
                return classArray[0];
            }
        }
        throw new ClassFormatError(new StringBuffer().append("Too many outer classes :").append(classArray.length).toString());
    }

    public Class[] getClasses() {
        SecurityManager securityManager = System.getSecurityManager();
        Vector vector = new Vector();
        Class clazz = this;
        while (clazz != null) {
            if (securityManager != null) {
                securityManager.checkMemberAccess(clazz, 0);
            }
            Class[] classArray = clazz.getClasses0(true);
            int n = 0;
            while (n < classArray.length) {
                if (Modifier.isPublic(classArray[n].getModifiers())) {
                    vector.add(classArray[n]);
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        return (Class[])vector.toArray(new Class[vector.size()]);
    }

    private native Class[] getClasses0(boolean var1);

    public native Class getComponentType();

    public Constructor getConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getConstructor0(classArray, false);
    }

    private native Constructor getConstructor0(Class[] var1, boolean var2);

    public Constructor[] getConstructors() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getConstructors0(false);
    }

    private native Constructor[] getConstructors0(boolean var1);

    public Class[] getDeclaredClasses() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getClasses0(true);
    }

    public Constructor getDeclaredConstructor(Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getConstructor0(classArray, true);
    }

    public Constructor[] getDeclaredConstructors() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getConstructors0(true);
    }

    public Field getDeclaredField(String string) throws NoSuchFieldException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getFieldInternal(string, true);
    }

    public Field[] getDeclaredFields() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getFields0(true);
    }

    public Method getDeclaredMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getMethod0(string, classArray, true);
    }

    public Method[] getDeclaredMethods() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 1);
        }
        return this.getMethods0(true);
    }

    public Field getField(String string) throws NoSuchFieldException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getFieldInternal(string, false);
    }

    private Field getFieldInternal(String string, boolean bl) throws NoSuchFieldException {
        Field field = this.getField0(string, bl);
        if (field == null) {
            throw new NoSuchFieldException(new StringBuffer().append("Class ").append(this.getName()).append(" has no field named ").append(string).toString());
        }
        return field;
    }

    private native Field getField0(String var1, boolean var2);

    public Field[] getFields() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getFields0(false);
    }

    private native Field[] getFields0(boolean var1);

    public native Class[] getInterfaces();

    public Method getMethod(String string, Class[] classArray) throws NoSuchMethodException, SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        if (string.equals("<init>") || string.equals("<clinit>")) {
            throw new NoSuchMethodException();
        }
        return this.getMethod0(string, classArray, false);
    }

    private native Method getMethod0(String var1, Class[] var2, boolean var3);

    public Method[] getMethods() throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkMemberAccess(this, 0);
        }
        return this.getMethods0(false);
    }

    private native Method[] getMethods0(boolean var1);

    public native int getModifiers();

    public native String getName();

    public Package getPackage() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return PrimordialClassLoader.getSingleton().getPackage(PackageHelper.getPackageName(this));
        }
        return classLoader.getPackage(PackageHelper.getPackageName(this));
    }

    public ProtectionDomain getProtectionDomain() {
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return PrimordialClassLoader.getSingleton().getProtectionDomain(this);
        }
        return classLoader.getProtectionDomain(this);
    }

    static native Class getPrimitiveClass(String var0);

    public URL getResource(String string) {
        ClassLoader classLoader = this.getClassLoader();
        string = this.fullResourceName(string);
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        return classLoader.getResource(string);
    }

    public InputStream getResourceAsStream(String string) {
        ClassLoader classLoader = this.getClassLoader();
        string = this.fullResourceName(string);
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string);
        }
        return classLoader.getResourceAsStream(string);
    }

    public native Object[] getSigners();

    native void setSigners(Object[] var1);

    public native Class getSuperclass();

    public native boolean isArray();

    public native boolean isAssignableFrom(Class var1);

    public native boolean isInstance(Object var1);

    public native boolean isInterface();

    public native boolean isPrimitive();

    public Object newInstance() throws InstantiationException, IllegalAccessException {
        if (Modifier.isAbstract(this.getModifiers()) || this.isInterface() || this.isPrimitive()) {
            throw new InstantiationException(this.getName());
        }
        try {
            return this.getDeclaredConstructor(null).newInstance(null);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)invocationTargetException.getTargetException();
            }
            throw new InstantiationException(invocationTargetException.getTargetException().getMessage());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InstantiationException(noSuchMethodException.getMessage());
        }
    }

    public String toString() {
        return new StringBuffer().append(this.isInterface() ? "interface " : (this.isPrimitive() ? "" : "class ")).append(this.getName()).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean desiredAssertionStatus() {
        Object object;
        ClassLoader classLoader = this.getClassLoader();
        if (classLoader == null) {
            return true;
        }
        if (classLoader.classAssertionStatus != null) {
            ClassLoader classLoader2 = classLoader;
            synchronized (classLoader2) {
                object = classLoader.classAssertionStatus.get(this.getName());
                if (object != null) {
                    return object.equals(Boolean.TRUE);
                }
            }
        } else {
            object = ClassLoader.systemClassAssertionStatus.get(this.getName());
            if (object != null) {
                return object.equals(Boolean.TRUE);
            }
        }
        if (classLoader.packageAssertionStatus != null) {
            ClassLoader classLoader3 = classLoader;
            synchronized (classLoader3) {
                String string = Class.getPackagePortion(this.getName());
                if ("".equals(string)) {
                    object = classLoader.packageAssertionStatus.get(null);
                } else {
                    do {
                        object = classLoader.packageAssertionStatus.get(string);
                    } while (!"".equals(string = Class.getPackagePortion(string)) && object == null);
                }
                if (object != null) {
                    return object.equals(Boolean.TRUE);
                }
            }
        } else {
            String string = Class.getPackagePortion(this.getName());
            if ("".equals(string)) {
                object = ClassLoader.systemPackageAssertionStatus.get(null);
            } else {
                do {
                    object = ClassLoader.systemPackageAssertionStatus.get(string);
                } while (!"".equals(string = Class.getPackagePortion(string)) && object == null);
            }
            if (object != null) {
                return object.equals(Boolean.TRUE);
            }
        }
        return classLoader.defaultAssertionStatus;
    }

    private static String getPackagePortion(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return string.substring(0, n);
    }
}

