/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;
import kaffe.lang.AppClassLoader;
import kaffe.lang.PrimordialClassLoader;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ClassLoader {
    private final Hashtable loadedClasses;
    private final Set loadedLibraries;
    private final Hashtable loadedPackages;
    private final Hashtable protectionDomains;
    static final boolean systemDefaultAssertionStatus = true;
    boolean defaultAssertionStatus;
    static final Map systemPackageAssertionStatus = new HashMap();
    Map packageAssertionStatus;
    static final Map systemClassAssertionStatus = new HashMap();
    Map classAssertionStatus;
    private ProtectionDomain defaultProtectionDomain;
    private final ClassLoader parent;

    protected ClassLoader() {
        this(ClassLoader.getSystemClassLoader());
    }

    protected ClassLoader(ClassLoader classLoader) {
        this.Block$();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkCreateClassLoader();
        }
        this.parent = classLoader;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        return this.loadClass(string, false);
    }

    protected Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class clazz = this.findLoadedClass(string);
        if (clazz == null) {
            try {
                clazz = this.parent != null ? this.parent.loadClass(string, bl) : PrimordialClassLoader.getSingleton().loadClass(string, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (clazz == null && (clazz = this.findClass(string)) == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        throw new ClassNotFoundException(string);
    }

    protected final Class defineClass(byte[] byArray, int n, int n2) throws ClassFormatError {
        return this.defineClass(null, byArray, n, n2);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2) throws ClassFormatError {
        if (this.defaultProtectionDomain == null) {
            this.defaultProtectionDomain = new ProtectionDomain(null, null);
        }
        return this.defineClass(string, byArray, n, n2, this.defaultProtectionDomain);
    }

    protected final Class defineClass(String string, byte[] byArray, int n, int n2, ProtectionDomain protectionDomain) throws ClassFormatError {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        Class clazz = this.defineClass0(string, byArray, n, n2);
        if (string != null) {
            this.loadedClasses.put(string, clazz);
        } else {
            this.loadedClasses.put(clazz.getName(), clazz);
        }
        this.protectionDomains.put(clazz, protectionDomain);
        return clazz;
    }

    protected final void resolveClass(Class clazz) {
        this.resolveClass0(clazz);
    }

    protected final Class findSystemClass(String string) throws ClassNotFoundException {
        return ClassLoader.getSystemClassLoader().loadClass(string);
    }

    public final ClassLoader getParent() {
        return this.parent;
    }

    protected final void setSigners(Class clazz, Object[] objectArray) {
        throw new NotImplemented(new StringBuffer().append(this.getClass().getName()).append(".setSigners()").toString());
    }

    protected final Class findLoadedClass(String string) {
        return (Class)this.loadedClasses.get(string);
    }

    public URL getResource(String string) {
        URL uRL = null;
        uRL = this.parent != null ? this.parent.getResource(string) : PrimordialClassLoader.getSingleton().findResource(string);
        if (uRL == null) {
            uRL = this.findResource(string);
        }
        return uRL;
    }

    public final Enumeration getResources(String string) throws IOException {
        Enumeration enumeration;
        Vector vector = new Vector();
        if (this.parent != null) {
            enumeration = this.parent.getResources(string);
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        } else {
            enumeration = PrimordialClassLoader.getSingleton().findResources(string);
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        enumeration = this.findResources(string);
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector.elements();
    }

    protected Enumeration findResources(String string) throws IOException {
        return new Vector().elements();
    }

    protected URL findResource(String string) {
        try {
            return (URL)this.findResources(string).nextElement();
        }
        catch (IOException iOException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return null;
    }

    public static URL getSystemResource(String string) {
        return ClassLoader.getSystemClassLoader().getResource(string);
    }

    public static Enumeration getSystemResources(String string) throws IOException {
        return ClassLoader.getSystemClassLoader().getResources(string);
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL = this.getResource(string);
        if (uRL != null) {
            try {
                return uRL.openStream();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public static InputStream getSystemResourceAsStream(String string) {
        return ClassLoader.getSystemClassLoader().getResourceAsStream(string);
    }

    public static ClassLoader getSystemClassLoader() {
        return AppClassLoader.getSingleton();
    }

    protected Package definePackage(String string, String string2, String string3, String string4, String string5, String string6, String string7, URL uRL) throws IllegalArgumentException {
        Package package_ = this.getPackage(string);
        if (package_ != null) {
            throw new IllegalArgumentException(new StringBuffer().append("Package ").append(string).append(" already defined").toString());
        }
        package_ = new Package(string, string2, string3, string4, string5, string6, string7, uRL);
        this.loadedPackages.put(string, package_);
        return package_;
    }

    protected Package getPackage(String string) {
        Package package_ = null;
        package_ = this.parent != null ? this.parent.getPackage(string) : PrimordialClassLoader.getSingleton().getPackage(string);
        if (package_ == null) {
            package_ = (Package)this.loadedPackages.get(string);
        }
        return package_;
    }

    protected Package[] getPackages() {
        Object[] objectArray = new Package[this.loadedPackages.size()];
        this.loadedPackages.values().toArray(objectArray);
        Package[] packageArray = null;
        packageArray = this.parent != null ? this.parent.getPackages() : PrimordialClassLoader.getSingleton().getPackages();
        Package[] packageArray2 = new Package[objectArray.length + packageArray.length];
        System.arraycopy(packageArray2, 0, packageArray, 0, packageArray.length);
        System.arraycopy(packageArray2, packageArray.length, objectArray, 0, objectArray.length);
        return packageArray2;
    }

    protected String findLibrary(String string) {
        return null;
    }

    synchronized void addNativeLibrary(NativeLibrary nativeLibrary) {
        this.loadedLibraries.add(nativeLibrary);
    }

    ProtectionDomain getProtectionDomain(Class clazz) {
        return (ProtectionDomain)this.protectionDomains.get(clazz);
    }

    private native Class defineClass0(String var1, byte[] var2, int var3, int var4);

    private native void resolveClass0(Class var1);

    public void setDefaultAssertionStatus(boolean bl) {
        this.defaultAssertionStatus = bl;
    }

    public synchronized void setPackageAssertionStatus(String string, boolean bl) {
        if (this.packageAssertionStatus == null) {
            this.packageAssertionStatus = new HashMap(systemPackageAssertionStatus);
        }
        this.packageAssertionStatus.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void setClassAssertionStatus(String string, boolean bl) {
        if (this.classAssertionStatus == null) {
            this.classAssertionStatus = new HashMap(systemClassAssertionStatus);
        }
        this.classAssertionStatus.put(string.toString(), bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public synchronized void clearAssertionStatus() {
        this.defaultAssertionStatus = false;
        this.packageAssertionStatus = new HashMap();
        this.classAssertionStatus = new HashMap();
    }

    private /* synthetic */ void Block$() {
        this.loadedClasses = new Hashtable();
        this.loadedLibraries = new HashSet();
        this.loadedPackages = new Hashtable();
        this.protectionDomains = new Hashtable();
        this.defaultAssertionStatus = true;
    }
}

