/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.PropertyPermission;
import kaffe.io.StdErrorStream;
import kaffe.io.StdInputStream;
import kaffe.io.StdOutputStream;
import kaffe.lang.ThreadStack;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static Properties props;
    private static SecurityManager security;

    private System() {
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    private static void checkPropertiesAccess() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertiesAccess();
        }
    }

    private static void checkPropertyAccess(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (securityManager != null) {
            securityManager.checkPropertyAccess(string);
        }
    }

    public static native long currentTimeMillis();

    public static void exit(int n) {
        Runtime.getRuntime().exit(n);
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    public static Properties getProperties() {
        System.checkPropertiesAccess();
        return props;
    }

    public static String getProperty(String string) {
        System.checkPropertyAccess(string);
        return props.getProperty(string);
    }

    public static String getProperty(String string, String string2) {
        System.checkPropertyAccess(string);
        return props.getProperty(string, string2);
    }

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static String getenv(String string) {
        throw new Error("System.getenv no longer supported");
    }

    public static native int identityHashCode(Object var0);

    private static native Properties initProperties(Properties var0);

    public static void load(String string) {
        Runtime.getRuntime().load(string, ThreadStack.getCallersClassLoader(false));
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary(string, ThreadStack.getCallersClassLoader(false));
    }

    public static String mapLibraryName(String string) {
        return new StringBuffer().append(NativeLibrary.getLibPrefix()).append(string).append(NativeLibrary.getLibSuffix()).toString();
    }

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void runFinalizersOnExit(boolean bl) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl);
    }

    private static void exitJavaCleanup() {
        Runtime.getRuntime().exitJavaCleanup();
    }

    public static void setErr(PrintStream printStream) {
        System.setErr0(printStream);
    }

    private static native void setErr0(PrintStream var0);

    public static void setIn(InputStream inputStream) {
        System.setIn0(inputStream);
    }

    private static native void setIn0(InputStream var0);

    public static void setOut(PrintStream printStream) {
        System.setOut0(printStream);
    }

    private static native void setOut0(PrintStream var0);

    public static String setProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new PropertyPermission(string, "write"));
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("key can't be empty");
        }
        return (String)props.setProperty(string, string2);
    }

    public static void setProperties(Properties properties) {
        System.checkPropertiesAccess();
        if (properties == null) {
            props.clear();
            return;
        }
        props = properties;
    }

    public static void setSecurityManager(SecurityManager securityManager) {
        if (security != null) {
            security.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        security = securityManager;
    }

    static {
        props = System.initProperties(new Properties());
        if (props.getProperty("kaffe.embedded", "false").equals("false")) {
            in = new BufferedInputStream(new FileInputStream(FileDescriptor.in), 128);
            out = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.out), 128), true);
            err = new PrintStream(new BufferedOutputStream(new FileOutputStream(FileDescriptor.err), 128), true);
        } else {
            in = new BufferedInputStream(new StdInputStream(), 128);
            out = new PrintStream(new BufferedOutputStream(new StdOutputStream(), 128), true);
            err = new PrintStream(new BufferedOutputStream(new StdErrorStream(), 128), true);
        }
    }
}

