/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Array {
    private static final Map typeCache = new HashMap();
    private static final String SEPARATOR = ".";

    private Array() {
    }

    private static void checkComponentType(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (clazz == Void.TYPE) {
            throw new IllegalArgumentException();
        }
    }

    public static Object get(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof Object[]) {
            return ((Object[])object)[n];
        }
        if (object instanceof boolean[]) {
            return new Boolean(((boolean[])object)[n]);
        }
        if (object instanceof byte[]) {
            return new Byte(((byte[])object)[n]);
        }
        if (object instanceof short[]) {
            return new Short(((short[])object)[n]);
        }
        if (object instanceof char[]) {
            return new Character(((char[])object)[n]);
        }
        if (object instanceof int[]) {
            return new Integer(((int[])object)[n]);
        }
        if (object instanceof long[]) {
            return new Long(((long[])object)[n]);
        }
        if (object instanceof float[]) {
            return new Float(((float[])object)[n]);
        }
        if (object instanceof double[]) {
            return new Double(((double[])object)[n]);
        }
        throw new IllegalArgumentException();
    }

    private static Class getArrayType(Class clazz, int n) {
        Class clazz2 = Array.getCachedType(clazz, n);
        if (clazz2 != null) {
            return clazz2;
        }
        Class clazz3 = Array.newInstance(clazz, 0).getClass();
        if (n == 1) {
            Array.putTypeInCache(clazz, n, clazz3);
            return clazz3;
        }
        StringBuffer stringBuffer = new StringBuffer(n - 1);
        int n2 = 0;
        while (n2 < n - 1) {
            stringBuffer.append('[');
            ++n2;
        }
        stringBuffer.append(clazz3.getName());
        try {
            Class clazz4 = Class.forName(stringBuffer.toString());
            Array.putTypeInCache(clazz, n, clazz4);
            return clazz4;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new InternalError(classNotFoundException.getMessage());
        }
    }

    public static boolean getBoolean(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof boolean[]) {
            return ((boolean[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static byte getByte(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    private static Class getCachedType(Class clazz, int n) {
        return (Class)typeCache.get(Array.mangle(clazz, n));
    }

    public static char getChar(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof char[]) {
            return ((char[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static double getDouble(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof double[]) {
            return ((double[])object)[n];
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        if (object instanceof short[]) {
            return ((short[])object)[n];
        }
        if (object instanceof char[]) {
            return ((char[])object)[n];
        }
        if (object instanceof int[]) {
            return ((int[])object)[n];
        }
        if (object instanceof long[]) {
            return ((long[])object)[n];
        }
        if (object instanceof float[]) {
            return ((float[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static float getFloat(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof float[]) {
            return ((float[])object)[n];
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        if (object instanceof short[]) {
            return ((short[])object)[n];
        }
        if (object instanceof char[]) {
            return ((char[])object)[n];
        }
        if (object instanceof int[]) {
            return ((int[])object)[n];
        }
        if (object instanceof long[]) {
            return ((long[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static int getInt(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof int[]) {
            return ((int[])object)[n];
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        if (object instanceof short[]) {
            return ((short[])object)[n];
        }
        if (object instanceof char[]) {
            return ((char[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static long getLong(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof long[]) {
            return ((long[])object)[n];
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        if (object instanceof short[]) {
            return ((short[])object)[n];
        }
        if (object instanceof char[]) {
            return ((char[])object)[n];
        }
        if (object instanceof int[]) {
            return ((int[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static short getShort(Object object, int n) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof short[]) {
            return ((short[])object)[n];
        }
        if (object instanceof byte[]) {
            return ((byte[])object)[n];
        }
        throw new IllegalArgumentException();
    }

    public static native int getLength(Object var0) throws IllegalArgumentException;

    private static String mangle(Class clazz, int n) {
        return new StringBuffer().append(clazz.getName()).append(SEPARATOR).append(n).toString();
    }

    private static native Object newArray(Class var0, int var1);

    public static Object newInstance(Class clazz, int n) throws NegativeArraySizeException {
        Array.checkComponentType(clazz);
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        if (!clazz.isPrimitive()) {
            return Array.newArray(clazz, n);
        }
        if (clazz == Boolean.TYPE) {
            return new boolean[n];
        }
        if (clazz == Byte.TYPE) {
            return new byte[n];
        }
        if (clazz == Short.TYPE) {
            return new short[n];
        }
        if (clazz == Character.TYPE) {
            return new char[n];
        }
        if (clazz == Integer.TYPE) {
            return new int[n];
        }
        if (clazz == Long.TYPE) {
            return new long[n];
        }
        if (clazz == Float.TYPE) {
            return new float[n];
        }
        if (clazz == Double.TYPE) {
            return new double[n];
        }
        throw new Error();
    }

    public static Object newInstance(Class clazz, int[] nArray) throws IllegalArgumentException, NegativeArraySizeException {
        Array.checkComponentType(clazz);
        if (nArray.length == 0 || nArray.length > 255) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] < 0) {
                throw new NegativeArraySizeException();
            }
            ++n;
        }
        return Array.newInstanceInternal(clazz, nArray, 0);
    }

    private static Object newInstanceInternal(Class clazz, int[] nArray, int n) {
        if (n == nArray.length - 1) {
            return Array.newInstance(clazz, nArray[n]);
        }
        Class clazz2 = Array.getArrayType(clazz, nArray.length - 1 - n);
        Object[] objectArray = (Object[])Array.newInstance(clazz2, nArray[n]);
        int n2 = nArray[n] - 1;
        while (n2 >= 0) {
            objectArray[n2] = Array.newInstanceInternal(clazz, nArray, n + 1);
            --n2;
        }
        return objectArray;
    }

    private static void putTypeInCache(Class clazz, int n, Class clazz2) {
        typeCache.put(Array.mangle(clazz, n), clazz2);
    }

    public static void set(Object object, int n, Object object2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof Object[]) {
            try {
                ((Object[])object)[n] = object2;
                return;
            }
            catch (ArrayStoreException arrayStoreException) {
                throw new IllegalArgumentException();
            }
        }
        if (object2 instanceof Boolean) {
            Array.setBoolean(object, n, (Boolean)object2);
            return;
        }
        if (object2 instanceof Byte) {
            Array.setByte(object, n, (Byte)object2);
            return;
        }
        if (object2 instanceof Short) {
            Array.setShort(object, n, (Short)object2);
            return;
        }
        if (object2 instanceof Character) {
            Array.setChar(object, n, ((Character)object2).charValue());
            return;
        }
        if (object2 instanceof Integer) {
            Array.setInt(object, n, (Integer)object2);
            return;
        }
        if (object2 instanceof Long) {
            Array.setLong(object, n, (Long)object2);
            return;
        }
        if (object2 instanceof Float) {
            Array.setFloat(object, n, ((Float)object2).floatValue());
            return;
        }
        if (object2 instanceof Double) {
            Array.setDouble(object, n, (Double)object2);
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setBoolean(Object object, int n, boolean bl) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof boolean[]) {
            ((boolean[])object)[n] = bl;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setByte(Object object, int n, byte by) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof byte[]) {
            ((byte[])object)[n] = by;
            return;
        }
        if (object instanceof short[]) {
            ((short[])object)[n] = by;
            return;
        }
        if (object instanceof int[]) {
            ((int[])object)[n] = by;
            return;
        }
        if (object instanceof long[]) {
            ((long[])object)[n] = by;
            return;
        }
        if (object instanceof float[]) {
            ((float[])object)[n] = by;
            return;
        }
        if (object instanceof double[]) {
            ((double[])object)[n] = by;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setChar(Object object, int n, char c) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof char[]) {
            ((char[])object)[n] = c;
            return;
        }
        if (object instanceof int[]) {
            ((int[])object)[n] = c;
            return;
        }
        if (object instanceof long[]) {
            ((long[])object)[n] = c;
            return;
        }
        if (object instanceof float[]) {
            ((float[])object)[n] = c;
            return;
        }
        if (object instanceof double[]) {
            ((double[])object)[n] = c;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setDouble(Object object, int n, double d) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof double[]) {
            ((double[])object)[n] = d;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setFloat(Object object, int n, float f) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof float[]) {
            ((float[])object)[n] = f;
            return;
        }
        if (object instanceof double[]) {
            ((double[])object)[n] = f;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setInt(Object object, int n, int n2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof int[]) {
            ((int[])object)[n] = n2;
            return;
        }
        if (object instanceof long[]) {
            ((long[])object)[n] = n2;
            return;
        }
        if (object instanceof float[]) {
            ((float[])object)[n] = n2;
            return;
        }
        if (object instanceof double[]) {
            ((double[])object)[n] = n2;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setLong(Object object, int n, long l) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof long[]) {
            ((long[])object)[n] = l;
            return;
        }
        if (object instanceof float[]) {
            ((float[])object)[n] = l;
            return;
        }
        if (object instanceof double[]) {
            ((double[])object)[n] = l;
            return;
        }
        throw new IllegalArgumentException();
    }

    public static void setShort(Object object, int n, short s) throws IllegalArgumentException, ArrayIndexOutOfBoundsException {
        if (object instanceof short[]) {
            ((short[])object)[n] = s;
            return;
        }
        if (object instanceof int[]) {
            ((int[])object)[n] = s;
            return;
        }
        if (object instanceof long[]) {
            ((long[])object)[n] = s;
            return;
        }
        if (object instanceof float[]) {
            ((float[])object)[n] = s;
            return;
        }
        if (object instanceof double[]) {
            ((double[])object)[n] = s;
            return;
        }
        throw new IllegalArgumentException();
    }
}

