/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimal
extends Number
implements Comparable {
    private static final long serialVersionUID = 6108874887143696463L;
    public static final int ROUND_UP = 0;
    public static final int ROUND_DOWN = 1;
    public static final int ROUND_CEILING = 2;
    public static final int ROUND_FLOOR = 3;
    public static final int ROUND_HALF_UP = 4;
    public static final int ROUND_HALF_DOWN = 5;
    public static final int ROUND_HALF_EVEN = 6;
    public static final int ROUND_UNNECESSARY = 7;
    private BigInteger num;
    private int scale;

    public BigDecimal(String string) {
        int n = string.indexOf(46);
        if (n == -1) {
            this.num = new BigInteger(string, 10);
            return;
        }
        this.num = new BigInteger(new StringBuffer().append(string.substring(0, n)).append(string.substring(n + 1)).toString(), 10);
        this.scale = string.length() - n - 1;
    }

    /*
     * Unable to fully structure code
     */
    public BigDecimal(double var1_1) {
        super();
        if (Double.isInfinite(var1_1) || Double.isNaN(var1_1)) {
            throw new NumberFormatException("Infinite or NaN");
        }
        var3_2 = Double.doubleToLongBits(var1_1);
        var5_3 = var3_2 >> 63 == 0L ? 1 : -1;
        var6_4 = (int)(var3_2 >> 52 & 2047L);
        var7_5 = var6_4 == 0 ? (var3_2 & 0xFFFFFFFFFFFFFL) << 1 : var3_2 & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        var6_4 -= 1075;
        if (var7_5 != 0L) ** GOTO lbl14
        this.num = BigInteger.ZERO;
        return;
lbl-1000:
        // 1 sources

        {
            var7_5 >>= 1;
            ++var6_4;
lbl14:
            // 2 sources

            ** while ((var7_5 & 1L) == 0L)
        }
lbl15:
        // 1 sources

        this.num = BigInteger.valueOf((long)var5_3 * var7_5);
        if (var6_4 > 0) {
            this.num = this.num.multiply(BigInteger.valueOf(2L).pow(var6_4));
            return;
        }
        if (var6_4 < 0) {
            this.num = this.num.multiply(BigInteger.valueOf(5L).pow(-var6_4));
            this.scale = -var6_4;
        }
    }

    public BigDecimal(BigInteger bigInteger) {
        this.num = bigInteger;
    }

    public BigDecimal(BigInteger bigInteger, int n) {
        if (n < 0) {
            throw new NumberFormatException(new StringBuffer().append("Negative scale: ").append(n).toString());
        }
        this.num = bigInteger;
        this.scale = n;
    }

    public static BigDecimal valueOf(long l, int n) {
        return new BigDecimal(BigInteger.valueOf(l), n);
    }

    public static BigDecimal valueOf(long l) {
        return BigDecimal.valueOf(l, 0);
    }

    public BigDecimal add(BigDecimal bigDecimal) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n;
        int n2 = this.scale - bigDecimal.scale;
        if (n2 == 0) {
            n = this.scale;
            bigInteger2 = this.num;
            bigInteger = bigDecimal.num;
        } else if (n2 > 0) {
            n = this.scale;
            bigInteger2 = this.num;
            bigInteger = BigDecimal.mul10n(bigDecimal.num, n2);
        } else {
            n = bigDecimal.scale;
            bigInteger2 = BigDecimal.mul10n(this.num, -n2);
            bigInteger = bigDecimal.num;
        }
        return new BigDecimal(bigInteger2.add(bigInteger), n);
    }

    public BigDecimal subtract(BigDecimal bigDecimal) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n;
        int n2 = this.scale - bigDecimal.scale;
        if (n2 == 0) {
            n = this.scale;
            bigInteger2 = this.num;
            bigInteger = bigDecimal.num;
        } else if (n2 > 0) {
            n = this.scale;
            bigInteger2 = this.num;
            bigInteger = BigDecimal.mul10n(bigDecimal.num, n2);
        } else {
            n = bigDecimal.scale;
            bigInteger2 = BigDecimal.mul10n(this.num, -n2);
            bigInteger = bigDecimal.num;
        }
        return new BigDecimal(bigInteger2.subtract(bigInteger), n);
    }

    public BigDecimal multiply(BigDecimal bigDecimal) {
        return new BigDecimal(this.num.multiply(bigDecimal.num), this.scale + bigDecimal.scale);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n, int n2) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (n < 0) {
            throw new NumberFormatException(new StringBuffer().append("Negative scale: ").append(n).toString());
        }
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException(new StringBuffer().append("Illegal rounding mode: ").append(n2).toString());
        }
        int n3 = this.scale - n - bigDecimal.scale;
        if (n3 == 0) {
            bigInteger2 = this.num;
            bigInteger = bigDecimal.num;
        } else if (n3 > 0) {
            bigInteger2 = this.num;
            bigInteger = BigDecimal.mul10n(bigDecimal.num, n3);
        } else {
            bigInteger2 = BigDecimal.mul10n(this.num, -n3);
            bigInteger = bigDecimal.num;
        }
        BigInteger[] bigIntegerArray = bigInteger2.divideAndRemainder(bigInteger);
        BigInteger bigInteger3 = bigIntegerArray[0];
        BigInteger bigInteger4 = bigIntegerArray[1];
        if (bigInteger4.signum() == 0) {
            return new BigDecimal(bigInteger3, n);
        }
        int n4 = bigInteger2.signum() * bigInteger.signum();
        int n5 = bigInteger4.abs().multiply(BigInteger.valueOf(2L)).compareTo(bigInteger.abs());
        switch (n2) {
            case 2: {
                n2 = n4 > 0 ? 0 : 1;
                break;
            }
            case 3: {
                n2 = n4 > 0 ? 1 : 0;
                break;
            }
            case 4: {
                n2 = n5 >= 0 ? 0 : 1;
                break;
            }
            case 5: {
                n2 = n5 > 0 ? 0 : 1;
                break;
            }
            case 6: {
                if (n5 == 0) {
                    n2 = bigInteger3.testBit(0) ? 0 : 1;
                    break;
                }
                n2 = n5 > 0 ? 0 : 1;
                break;
            }
            case 7: {
                throw new ArithmeticException("Rounding necessary");
            }
        }
        return new BigDecimal(n2 == 0 ? bigInteger3.add(BigInteger.ONE) : bigInteger3, n);
    }

    public BigDecimal divide(BigDecimal bigDecimal, int n) {
        return this.divide(bigDecimal, this.scale, n);
    }

    public BigDecimal abs() {
        if (this.num.signum() < 0) {
            return this.negate();
        }
        return this;
    }

    public BigDecimal negate() {
        return new BigDecimal(this.num.negate(), this.scale);
    }

    public int signum() {
        return this.num.signum();
    }

    public int scale() {
        return this.scale;
    }

    public BigInteger unscaledValue() {
        return this.num;
    }

    public BigDecimal setScale(int n, int n2) {
        if (n < 0) {
            throw new ArithmeticException(new StringBuffer().append("Negative scale: ").append(n).toString());
        }
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException(new StringBuffer().append("Illegal rounding mode: ").append(n2).toString());
        }
        if (this.scale == n) {
            return this;
        }
        if (this.scale < n) {
            return new BigDecimal(BigDecimal.mul10n(this.num, n - this.scale), n);
        }
        return this.divide(BigDecimal.valueOf(1L), n, n2);
    }

    public BigDecimal setScale(int n) {
        return this.setScale(n, 7);
    }

    public BigDecimal movePointLeft(int n) {
        if (n < 0) {
            return this.movePointRight(-n);
        }
        return new BigDecimal(this.num, this.scale + n);
    }

    public BigDecimal movePointRight(int n) {
        if (this.scale >= n) {
            return new BigDecimal(this.num, this.scale - n);
        }
        return new BigDecimal(BigDecimal.mul10n(this.num, n - this.scale), 0);
    }

    public int compareTo(BigDecimal bigDecimal) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        int n = this.scale - bigDecimal.scale;
        if (n == 0) {
            bigInteger2 = this.num;
            bigInteger = bigDecimal.num;
        } else if (n > 0) {
            bigInteger2 = this.num;
            bigInteger = BigDecimal.mul10n(bigDecimal.num, n);
        } else {
            bigInteger2 = BigDecimal.mul10n(this.num, -n);
            bigInteger = bigDecimal.num;
        }
        return bigInteger2.compareTo(bigInteger);
    }

    @Override
    public int compareTo(Object object) {
        return this.compareTo((BigDecimal)object);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BigDecimal)) {
            return false;
        }
        BigDecimal bigDecimal = (BigDecimal)object;
        return this.scale == bigDecimal.scale && this.num.equals(bigDecimal.num);
    }

    public BigDecimal min(BigDecimal bigDecimal) {
        if (this.compareTo(bigDecimal) < 0) {
            return this;
        }
        return bigDecimal;
    }

    public BigDecimal max(BigDecimal bigDecimal) {
        if (this.compareTo(bigDecimal) < 0) {
            return bigDecimal;
        }
        return this;
    }

    public int hashCode() {
        return this.num.hashCode() ^ this.scale;
    }

    public String toString() {
        if (this.scale == 0) {
            return this.num.toString();
        }
        String string = this.num.abs().toString();
        int n = string.length() - this.scale;
        StringBuffer stringBuffer = new StringBuffer(string.length() + (n <= 0 ? 3 - n : 2));
        while (n <= 0) {
            stringBuffer.append('0');
            ++n;
        }
        stringBuffer.append(string);
        stringBuffer.insert(n, '.');
        if (this.num.signum() < 0) {
            stringBuffer.insert(0, '-');
        }
        return stringBuffer.toString();
    }

    public BigInteger toBigInteger() {
        if (this.scale == 0) {
            return this.num;
        }
        return this.num.divide(BigDecimal.pow10(this.scale));
    }

    @Override
    public int intValue() {
        return this.toBigInteger().intValue();
    }

    @Override
    public long longValue() {
        return this.toBigInteger().longValue();
    }

    @Override
    public float floatValue() {
        return Float.valueOf(this.toString()).floatValue();
    }

    @Override
    public double doubleValue() {
        return Double.valueOf(this.toString());
    }

    private static BigInteger pow10(int n) {
        return BigInteger.valueOf(10L).pow(n);
    }

    private static BigInteger mul10n(BigInteger bigInteger, int n) {
        return bigInteger.multiply(BigInteger.valueOf(10L).pow(n));
    }
}

