/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.DatagramSocketImplFactory;
import java.net.InetAddress;
import java.net.SocketException;
import kaffe.net.DefaultDatagramSocketImplFactory;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatagramSocket {
    private InetAddress address;
    private int port;
    private static DatagramSocketImplFactory factory = new DefaultDatagramSocketImplFactory();
    protected DatagramSocketImpl impl;

    public DatagramSocket() throws SocketException {
        this(0, null);
    }

    public DatagramSocket(int n) throws SocketException {
        this(n, null);
    }

    public DatagramSocket(int n, InetAddress inetAddress) throws SocketException {
        this.Block$();
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkListen(n);
        }
        if (inetAddress == null) {
            inetAddress = InetAddress.getAnyAddress();
        }
        this.impl = factory.createDatagramSocketImpl();
        this.impl.create();
        this.init(n, inetAddress);
    }

    protected void init(int n, InetAddress inetAddress) throws SocketException {
        this.impl.bind(n, inetAddress);
    }

    public synchronized void close() {
        this.impl.close();
    }

    public synchronized void connect(InetAddress inetAddress, int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException();
        }
        this.checkRemote(inetAddress, n);
        this.address = inetAddress;
        this.port = n;
    }

    public synchronized void disconnect() {
        this.address = null;
        this.port = -1;
    }

    public InetAddress getInetAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public void setSoTimeout(int n) throws SocketException {
        this.impl.setOption(4102, new Integer(n));
    }

    public int getSoTimeout() throws SocketException {
        return (Integer)this.impl.getOption(4102);
    }

    public void setSendBufferSize(int n) throws SocketException {
        this.impl.setOption(4097, new Integer(n));
    }

    public void setReceiveBufferSize(int n) throws SocketException {
        this.impl.setOption(4098, new Integer(n));
    }

    public int getSendBufferSize() throws SocketException {
        return (Integer)this.impl.getOption(4097);
    }

    public int getReceiveBufferSize() throws SocketException {
        return (Integer)this.impl.getOption(4098);
    }

    public int getLocalPort() {
        return this.impl.getLocalPort();
    }

    public InetAddress getLocalAddress() {
        try {
            return (InetAddress)this.impl.getOption(15);
        }
        catch (Exception exception) {
            return InetAddress.getLoopback();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void receive(DatagramPacket datagramPacket) throws IOException {
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            do {
                datagramPacket.prime();
                this.impl.receive(datagramPacket);
                if (this.address != null) continue;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager == null) break;
                securityManager.checkAccept(datagramPacket.getAddress().getHostName(), datagramPacket.getPort());
                break;
            } while (!this.address.equals(datagramPacket.getAddress()) || this.port != datagramPacket.getPort());
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(DatagramPacket datagramPacket) throws IOException {
        DatagramPacket datagramPacket2 = datagramPacket;
        synchronized (datagramPacket2) {
            if (this.address == null) {
                if (datagramPacket.getAddress() == null || datagramPacket.getPort() == -1) {
                    throw new IOException("no destination");
                }
                this.checkRemote(datagramPacket.getAddress(), datagramPacket.getPort());
            } else if (datagramPacket.getAddress() == null) {
                datagramPacket.setAddress(this.address);
                datagramPacket.setPort(this.port);
            } else if (!datagramPacket.getAddress().equals(this.address) || this.port != datagramPacket.getPort()) {
                throw new IllegalArgumentException("address mismatch");
            }
            this.impl.send(datagramPacket);
            return;
        }
    }

    private void checkRemote(InetAddress inetAddress, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (inetAddress.isMulticastAddress()) {
                securityManager.checkMulticast(inetAddress);
                return;
            }
            securityManager.checkConnect(inetAddress.getHostName(), n);
        }
    }

    private /* synthetic */ void Block$() {
        this.port = -1;
    }
}

