/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.ObjectStreamException;
import java.net.InetAddress;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Inet4Address
extends InetAddress {
    static final long serialVersionUID = 7615067291688066509L;

    static byte[] fromString(String string) throws IllegalArgumentException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        byte[] byArray = new byte[4];
        try {
            int n = 0;
            while (n < byArray.length) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                if (n2 < 0 || n2 > 255) {
                    throw new IllegalArgumentException(new StringBuffer().append("IP address component out of range: ").append(n2).toString());
                }
                byArray[n] = (byte)n2;
                ++n;
            }
            if (stringTokenizer.hasMoreTokens()) {
                throw new IllegalArgumentException(new StringBuffer().append("Extraneous data after IP address: ").append(string).toString());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException);
        }
        return byArray;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new InetAddress(this.addr, this.hostName);
    }

    protected Inet4Address(byte[] byArray, String string) {
        super(byArray, string);
    }

    @Override
    public boolean isMulticastAddress() {
        return (this.addr[0] & 0xF0) == 224;
    }

    @Override
    public boolean isLoopbackAddress() {
        return this.addr[0] == 127;
    }

    @Override
    public boolean isAnyLocalAddress() {
        return this.address == 0;
    }

    @Override
    public boolean isLinkLocalAddress() {
        return false;
    }

    @Override
    public boolean isSiteLocalAddress() {
        if (this.addr[0] == 10) {
            return true;
        }
        if (this.addr[0] == 172 && (this.addr[1] & 0xF0) == 1) {
            return true;
        }
        return this.addr[0] == 192 && this.addr[1] == 168;
    }

    @Override
    public boolean isMCGlobal() {
        return false;
    }

    @Override
    public boolean isMCNodeLocal() {
        return false;
    }

    @Override
    public boolean isMCLinkLocal() {
        if (!this.isMulticastAddress()) {
            return false;
        }
        return this.addr[0] == 224 && this.addr[1] == 0 && this.addr[2] == 0;
    }

    @Override
    public boolean isMCSiteLocal() {
        return false;
    }

    @Override
    public boolean isMCOrgLocal() {
        return false;
    }

    @Override
    public byte[] getAddress() {
        return (byte[])this.addr.clone();
    }

    @Override
    public String getHostAddress() {
        StringBuffer stringBuffer = new StringBuffer(40);
        int n = this.addr.length;
        int n2 = 0;
        while (true) {
            stringBuffer.append(this.addr[n2] & 0xFF);
            if (++n2 == n) break;
            stringBuffer.append('.');
        }
        return stringBuffer.toString();
    }

    @Override
    public int hashCode() {
        int n = 0;
        int n2 = this.addr.length;
        int n3 = n2 > 4 ? n2 - 4 : 0;
        while (n3 < n2) {
            n = n << 8 | this.addr[n3] & 0xFF;
            ++n3;
        }
        return n;
    }
}

