/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddressImpl;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetAddress
implements Serializable {
    private static final long serialVersionUID = 3286316764910316507L;
    private static final int IPV4_LOOPBACK_BITS = 2130706433;
    private static final InetAddressImpl impl;
    static final String[] INET_ADDRESS_IMPLS;
    transient String hostName;
    transient byte[] addr;
    int address;
    private int family = InetAddressImpl.getInetFamily(this instanceof Inet6Address ? 2 : 1);

    private static int fromBytes(byte[] byArray) {
        int n = 0;
        if (byArray.length == 4) {
            n = (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
        }
        return n;
    }

    private static byte[] toBytes(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    InetAddress(byte[] byArray, int n, String string) {
        this.hostName = string;
        this.addr = byArray;
        this.address = n;
    }

    InetAddress(byte[] byArray, String string) {
        this(byArray, InetAddress.fromBytes(byArray), string);
    }

    InetAddress(int n, String string) {
        this(InetAddress.toBytes(n), n, string);
    }

    InetAddress() {
        this(null, 0, null);
    }

    public static InetAddress[] getAllByName(String string) throws UnknownHostException, SecurityException {
        InetAddress[] inetAddressArray;
        if (string == null || string.equals("") || string.equals("localhost")) {
            inetAddressArray = new InetAddress[]{new Inet4Address(InetAddress.toBytes(2130706433), "localhost")};
        } else {
            byte[] byArray;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string, -1);
            }
            Object object = (byArray = InetAddressImpl.stringToBits(string)) == null ? impl.lookupAllHostAddr(string) : (Object)new byte[][]{byArray};
            inetAddressArray = new InetAddress[((byte[][])object).length];
            int n = 0;
            while (n < ((byte[][])object).length) {
                switch (object[n].length) {
                    case 4: {
                        inetAddressArray[n] = new Inet4Address(object[n], byArray == null ? string : null);
                        break;
                    }
                    case 16: {
                        inetAddressArray[n] = new Inet6Address(object[n], byArray == null ? string : null);
                        break;
                    }
                    default: {
                        throw new InternalError(new StringBuffer().append("Unhandled address length: ").append(object[n].length).toString());
                    }
                }
                ++n;
            }
        }
        return inetAddressArray;
    }

    public static InetAddress getByAddress(byte[] byArray) throws UnknownHostException {
        InetAddress inetAddress;
        switch (byArray.length) {
            case 4: {
                inetAddress = new Inet4Address(byArray, null);
                break;
            }
            case 16: {
                inetAddress = new Inet6Address(byArray, null);
                break;
            }
            default: {
                throw new UnknownHostException(new StringBuffer().append("Bad address length: ").append(byArray.length).append(" bytes").toString());
            }
        }
        return inetAddress;
    }

    public static InetAddress getByName(String string) throws UnknownHostException {
        InetAddress inetAddress = null;
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        int n = 0;
        while (n < inetAddressArray.length && inetAddress == null) {
            if (inetAddressArray[n] instanceof Inet4Address) {
                inetAddress = inetAddressArray[n];
            }
            ++n;
        }
        if (inetAddress == null && inetAddressArray.length > 0) {
            inetAddress = inetAddressArray[0];
        }
        return inetAddress;
    }

    public static InetAddress getLocalHost() throws UnknownHostException {
        try {
            String string = InetAddressImpl.getLocalHostName();
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(string, 0);
            }
            return InetAddress.getByName(string);
        }
        catch (SecurityException securityException) {
            return InetAddress.getLoopback();
        }
    }

    public String getHostAddress() {
        return null;
    }

    public String getCanonicalHostName() {
        String string;
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkConnect(this.hostName, -1);
            }
            string = impl.getHostByAddr(this.addr);
        }
        catch (UnknownHostException unknownHostException) {
            string = this.getHostAddress();
        }
        catch (SecurityException securityException) {
            string = this.getHostAddress();
        }
        return string;
    }

    public String getHostName() {
        String string;
        try {
            if (this.hostName == null) {
                this.hostName = impl.getHostByAddr(this.addr);
            }
            string = this.hostName;
            try {
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    securityManager.checkConnect(this.hostName, -1);
                }
            }
            catch (SecurityException securityException) {
                string = this.getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            string = this.hostName = this.getHostAddress();
        }
        return string;
    }

    public boolean isMulticastAddress() {
        return false;
    }

    public boolean isAnyLocalAddress() {
        return false;
    }

    public boolean isLoopbackAddress() {
        return false;
    }

    public boolean isLinkLocalAddress() {
        return false;
    }

    public boolean isSiteLocalAddress() {
        return false;
    }

    public boolean isMCGlobal() {
        return false;
    }

    public boolean isMCNodeLocal() {
        return false;
    }

    public boolean isMCLinkLocal() {
        return false;
    }

    public boolean isMCSiteLocal() {
        return false;
    }

    public boolean isMCOrgLocal() {
        return false;
    }

    public byte[] getAddress() {
        return null;
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object object) {
        try {
            InetAddress inetAddress = (InetAddress)object;
            if (this.family == inetAddress.family && this.address == inetAddress.address) {
                return true;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.hostName == null) {
            stringBuffer.append("");
        } else {
            stringBuffer.append(this.hostName);
        }
        stringBuffer.append("/");
        stringBuffer.append(this.getHostAddress());
        return stringBuffer.toString();
    }

    static InetAddress getLoopback() {
        return new InetAddress(2130706433, "localhost");
    }

    InetAddress dup() {
        InetAddress inetAddress = new InetAddress();
        inetAddress.hostName = this.hostName == null ? null : new String(this.hostName.toCharArray());
        inetAddress.address = this.address;
        inetAddress.family = this.family;
        return inetAddress;
    }

    static InetAddress getAnyAddress() {
        return new InetAddress(new byte[]{0, 0, 0, 0}, null);
    }

    static {
        INET_ADDRESS_IMPLS = new String[]{"java.net.DNSJavaInetAddressImpl", "java.net.NativeInetAddressImpl"};
        InetAddressImpl inetAddressImpl = null;
        int n = 0;
        while (n < INET_ADDRESS_IMPLS.length && inetAddressImpl == null) {
            try {
                Class clazz = Class.forName(INET_ADDRESS_IMPLS[n]);
                inetAddressImpl = (InetAddressImpl)clazz.newInstance();
                System.setProperty("org.kaffe.dns", INET_ADDRESS_IMPLS[n]);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new InternalError(illegalAccessException);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            ++n;
        }
        if (inetAddressImpl == null) {
            throw new UnsatisfiedLinkError("Cannot find working InetAddressImpl");
        }
        impl = inetAddressImpl;
    }
}

