/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InetSocketAddress
extends SocketAddress {
    private static final InetAddress ANY_ADDRESS;
    private final String hostname;
    private final InetAddress addr;
    private final int port;

    private InetSocketAddress(String string, InetAddress inetAddress, int n) {
        if (n < 0 || n > 65535) {
            throw new IllegalArgumentException(new StringBuffer().append("Bad port number: ").append(n).toString());
        }
        if (string != null) {
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {}
        } else if (inetAddress == null) {
            inetAddress = ANY_ADDRESS;
            string = "*";
        } else {
            string = inetAddress.getHostName();
        }
        this.hostname = string;
        this.addr = inetAddress;
        this.port = n;
    }

    public InetSocketAddress(InetAddress inetAddress, int n) {
        this(null, inetAddress, n);
    }

    public InetSocketAddress(int n) {
        this(null, ANY_ADDRESS, n);
    }

    public InetSocketAddress(String string, int n) {
        this(string, null, n);
        if (string == null) {
            throw new IllegalArgumentException("Null host name value");
        }
    }

    public final int getPort() {
        return this.port;
    }

    public final InetAddress getAddress() {
        return this.addr;
    }

    public final String getHostName() {
        return this.hostname;
    }

    public final boolean isUnresolved() {
        return this.hostname != null && this.addr == null;
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)object;
            if (this.isUnresolved() == inetSocketAddress.isUnresolved() && this.port == inetSocketAddress.port) {
                if (this.addr != null) {
                    if (this.addr.equals(inetSocketAddress.addr)) {
                        bl = true;
                    }
                } else if (this.hostname.equals(inetSocketAddress.hostname)) {
                    bl = true;
                }
            }
        }
        return bl;
    }

    public final int hashCode() {
        return this.hostname.hashCode();
    }

    public String toString() {
        String string = this.isUnresolved() ? new StringBuffer().append(this.hostname).append(":").append(this.port).toString() : new StringBuffer().append(this.addr).append(":").append(this.port).toString();
        return string;
    }

    static {
        try {
            ANY_ADDRESS = InetAddress.getByAddress(new byte[]{0, 0, 0, 0});
            InetSocketAddress.ANY_ADDRESS.hostName = "";
            return;
        }
        catch (UnknownHostException unknownHostException) {
            throw new InternalError();
        }
    }
}

