/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JarURLConnection
extends URLConnection {
    protected URLConnection jarFileURLConnection;

    protected JarURLConnection(URL uRL) throws MalformedURLException {
        super(uRL);
    }

    public URL getJarFileURL() {
        try {
            return new URL(this.getURL().getHost());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public String getEntryName() {
        String string = this.getURL().getFile();
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    public abstract JarFile getJarFile() throws IOException;

    public Manifest getManifest() throws IOException {
        return this.getJarFile().getManifest();
    }

    public JarEntry getJarEntry() throws IOException {
        String string = this.getURL().getFile();
        if (string.equals("")) {
            return null;
        }
        JarEntry jarEntry = this.getJarFile().getJarEntry(string);
        if (jarEntry == null) {
            return null;
        }
        return jarEntry;
    }

    public Attributes getAttributes() throws IOException {
        String string = this.getURL().getFile();
        if (string.equals("")) {
            return null;
        }
        return this.getJarEntry().getAttributes();
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest manifest = this.getManifest();
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes();
    }
}

