/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocketImpl;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlainDatagramSocketImpl
extends DatagramSocketImpl {
    private int timeout;

    @Override
    protected void create() throws SocketException {
        this.datagramSocketCreate();
    }

    @Override
    protected void close() {
        this.datagramSocketClose();
    }

    @Override
    public void setOption(int n, Object object) throws SocketException {
        boolean bl;
        boolean bl2 = bl = object instanceof Boolean && (Boolean)object == false;
        if (bl) {
            object = new Integer(0);
        }
        switch (n) {
            case 4: 
            case 128: 
            case 4097: 
            case 4098: {
                break;
            }
            case 4102: {
                this.timeout = (Integer)object;
                return;
            }
            case 15: {
                throw new SocketException("Read-only socket option");
            }
            case 16: {
                if (bl) {
                    return;
                }
                object = (InetAddress)object;
                break;
            }
            default: {
                throw new SocketException("Unknown socket option");
            }
        }
        this.socketSetOption(n, object);
    }

    @Override
    public Object getOption(int n) throws SocketException {
        switch (n) {
            case 4: 
            case 128: 
            case 4097: 
            case 4098: {
                return new Integer(this.socketGetOption(n));
            }
            case 4102: {
                return new Integer(this.timeout);
            }
            case 15: 
            case 16: {
                int n2 = this.socketGetOption(n);
                try {
                    return InetAddress.getByName(new StringBuffer().append(n2 >> 24 & 0xFF).append(".").append(n2 >> 16 & 0xFF).append(".").append(n2 >> 8 & 0xFF).append(".").append(n2 & 0xFF).toString());
                }
                catch (UnknownHostException unknownHostException) {
                    throw new Error("impossible result");
                }
            }
        }
        throw new SocketException("Unknown socket option");
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    protected void setTimeToLive(byte by) throws IOException {
        this.setTTL(by);
    }

    @Override
    protected byte getTimeToLive() throws IOException {
        return this.getTTL();
    }

    @Override
    protected native void bind(int var1, InetAddress var2) throws SocketException;

    @Override
    protected native void send(DatagramPacket var1) throws IOException;

    @Override
    protected native int peek(InetAddress var1) throws IOException;

    @Override
    protected native void receive(DatagramPacket var1) throws IOException;

    @Override
    protected native void setTTL(byte var1) throws IOException;

    @Override
    protected native byte getTTL() throws IOException;

    @Override
    protected native void join(InetAddress var1) throws IOException;

    @Override
    protected native void leave(InetAddress var1) throws IOException;

    @Override
    protected native void joinGroup(SocketAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void leaveGroup(SocketAddress var1, NetworkInterface var2) throws IOException;

    protected native void socketSetOption(int var1, Object var2);

    protected native int socketGetOption(int var1);

    private native void datagramSocketCreate();

    private native void datagramSocketClose();

    static {
        System.loadLibrary("net");
    }
}

