/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URI
implements Comparable,
Serializable {
    static final long serialVersionUID = -6052424284110960213L;
    private static final String URI_REGEXP = "^(([^:/?#]+):)?((//([^/?#]*))?([^?#]*)(\\?([^#]*))?)?(#(.*))?";
    private static final int SCHEME_GROUP = 2;
    private static final int SCHEME_SPEC_PART_GROUP = 3;
    private static final int AUTHORITY_GROUP = 5;
    private static final int PATH_GROUP = 6;
    private static final int QUERY_GROUP = 8;
    private static final int FRAGMENT_GROUP = 10;
    String string;
    private String scheme;
    private String schemeSpecificPart;
    private String authority;
    private String userInfo;
    private String host;
    private int port;
    private String path;
    private String query;
    private String fragment;

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private static String getURIGroup(Matcher matcher, int n) {
        String string = matcher.group(n);
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    private void parseURI(String string) throws URISyntaxException {
        Pattern pattern = Pattern.compile(URI_REGEXP);
        Matcher matcher = pattern.matcher(string);
        if (matcher.matches()) {
            this.scheme = URI.getURIGroup(matcher, 2);
            this.schemeSpecificPart = URI.getURIGroup(matcher, 3);
            this.authority = URI.getURIGroup(matcher, 5);
            this.path = URI.getURIGroup(matcher, 6);
            this.query = URI.getURIGroup(matcher, 8);
            this.fragment = URI.getURIGroup(matcher, 10);
            return;
        }
        throw new URISyntaxException(string, "doesn't match URI regular expression");
    }

    private static String quote(String string) {
        return string;
    }

    private static String quoteAuthority(String string) {
        return string;
    }

    private static String quoteHost(String string) {
        return string;
    }

    private static String quotePath(String string) {
        return string;
    }

    private static String quoteUserInfo(String string) {
        return string;
    }

    public URI(String string) throws URISyntaxException {
        this.parseURI(string);
    }

    public URI(String string, String string2, String string3, int n, String string4, String string5, String string6) throws URISyntaxException {
        this(new StringBuffer().append("").append(string == null ? "" : new StringBuffer().append(string).append(":").toString()).append(string2 == null && string3 == null && n == -1 ? "" : "//").append(string2 == null ? "" : new StringBuffer().append(URI.quoteUserInfo(string2)).append("@").toString()).append(string3 == null ? "" : URI.quoteHost(string3)).append(n == -1 ? "" : new StringBuffer().append(":").append(String.valueOf(n)).toString()).append(string4 == null ? "" : URI.quotePath(string4)).append(string5 == null ? "" : new StringBuffer().append("?").append(URI.quote(string5)).toString()).append(string6 == null ? "" : new StringBuffer().append("#").append(URI.quote(string6)).toString()).toString());
        this.parseServerAuthority();
    }

    public URI(String string, String string2, String string3, String string4, String string5) throws URISyntaxException {
        this(new StringBuffer().append("").append(string == null ? "" : new StringBuffer().append(string).append(":").toString()).append(string2 == null ? "" : new StringBuffer().append("//").append(URI.quoteAuthority(string2)).toString()).append(string3 == null ? "" : URI.quotePath(string3)).append(string4 == null ? "" : new StringBuffer().append("?").append(URI.quote(string4)).toString()).append(string5 == null ? "" : new StringBuffer().append("#").append(URI.quote(string5)).toString()).toString());
    }

    public URI(String string, String string2, String string3, String string4) throws URISyntaxException {
        this(string, null, string2, -1, string3, null, string4);
    }

    public URI(String string, String string2, String string3) throws URISyntaxException {
        this(new StringBuffer().append("").append(string == null ? "" : new StringBuffer().append(string).append(":").toString()).append(string2 == null ? "" : URI.quote(string2)).append(string3 == null ? "" : new StringBuffer().append("#").append(URI.quote(string3)).toString()).toString());
    }

    public static URI create(String string) throws IllegalArgumentException {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IllegalArgumentException)new IllegalArgumentException().initCause(uRISyntaxException);
        }
    }

    public URI parseServerAuthority() throws URISyntaxException {
        return null;
    }

    public URI normalize() {
        return null;
    }

    public URI resolve(URI uRI) {
        if (uRI.isAbsolute()) {
            return uRI;
        }
        if (uRI.isOpaque()) {
            return uRI;
        }
        String string = uRI.getScheme();
        String string2 = uRI.getSchemeSpecificPart();
        String string3 = uRI.getAuthority();
        String string4 = uRI.getPath();
        String string5 = uRI.getQuery();
        String string6 = uRI.getFragment();
        try {
            if (string6 != null && string4 != null && string4.equals("") && string == null && string3 == null && string5 == null) {
                return new URI(this.scheme, this.schemeSpecificPart, string6);
            }
            if (string3 == null) {
                string3 = this.authority;
                if (string4 == null) {
                    string4 = "";
                }
                if (!string4.startsWith("/")) {
                    StringBuffer stringBuffer = new StringBuffer(this.path);
                    int n = this.path.lastIndexOf(47);
                    if (n >= 0) {
                        stringBuffer.delete(n + 1, stringBuffer.length());
                    }
                    stringBuffer.append(string4);
                    string4 = stringBuffer.toString();
                }
            }
            return new URI(this.scheme, string3, string4, string5, string6);
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public URI resolve(String string) throws IllegalArgumentException {
        return this.resolve(URI.create(string));
    }

    public URI relativize(URI uRI) {
        return null;
    }

    public URL toURL() throws IllegalArgumentException, MalformedURLException {
        return null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public boolean isOpaque() {
        return this.scheme != null && !this.schemeSpecificPart.startsWith("/");
    }

    public String getRawSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public String getSchemeSpecificPart() {
        return this.schemeSpecificPart;
    }

    public String getRawAuthority() {
        return this.authority;
    }

    public String getAuthority() {
        return this.authority;
    }

    public String getRawUserInfo() {
        return this.userInfo;
    }

    public String getUserInfo() {
        return this.userInfo;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRawPath() {
        return this.path;
    }

    public String getPath() {
        return this.path;
    }

    public String getRawQuery() {
        return this.query;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRawFragment() {
        return this.fragment;
    }

    public String getFragment() {
        return this.fragment;
    }

    public boolean equals(Object object) {
        return false;
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public int compareTo(Object object) throws ClassCastException {
        return 0;
    }

    public String toString() {
        return new StringBuffer().append("").append(this.getScheme() == null ? "" : new StringBuffer().append(this.getScheme()).append(":").toString()).append(this.getRawAuthority() == null ? "" : new StringBuffer().append("//").append(this.getRawAuthority()).toString()).append(this.getRawPath() == null ? "" : this.getRawPath()).append(this.getRawQuery() == null ? "" : new StringBuffer().append("?").append(this.getRawQuery()).toString()).append(this.getRawFragment() == null ? "" : new StringBuffer().append("#").append(this.getRawFragment()).toString()).toString();
    }

    public String toASCIIString() {
        return "";
    }
}

