/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharBufferImpl
extends CharBuffer {
    private boolean readOnly;

    CharBufferImpl(int n) {
        this(new char[n], 0, n, n, 0, -1, false);
    }

    CharBufferImpl(char[] cArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(cArray, n, n2, n3, n4, n5);
        this.readOnly = bl;
    }

    public CharBufferImpl(CharBufferImpl charBufferImpl) {
        super(charBufferImpl.capacity(), charBufferImpl.limit(), charBufferImpl.position(), 0);
        this.backing_buffer = charBufferImpl.backing_buffer;
        this.readOnly = charBufferImpl.isReadOnly();
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public CharBuffer slice() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public CharBuffer duplicate() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    @Override
    public CharBuffer asReadOnlyBuffer() {
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    @Override
    public CharBuffer compact() {
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        if (n < 0 || n > this.length() || n2 < n || n2 > this.length()) {
            throw new IndexOutOfBoundsException();
        }
        return new CharBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.position() + n2, this.position() + n, -1, this.isReadOnly());
    }

    @Override
    public final char get() {
        char c = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return c;
    }

    @Override
    public final CharBuffer put(char c) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = c;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final char get(int n) {
        if (n < 0 || n >= this.limit()) {
            throw new IndexOutOfBoundsException();
        }
        return this.backing_buffer[n];
    }

    @Override
    public final CharBuffer put(int n, char c) {
        if (n < 0 || n >= this.limit()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[n] = c;
        return this;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

