/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.FloatBufferImpl;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FloatBuffer
extends Buffer
implements Comparable {
    int array_offset;
    float[] backing_buffer;

    protected FloatBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.array_offset = 0;
    }

    FloatBuffer(float[] fArray, int n, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.backing_buffer = fArray;
        this.array_offset = n;
    }

    public static FloatBuffer allocate(int n) {
        return new FloatBufferImpl(n);
    }

    public static final FloatBuffer wrap(float[] fArray, int n, int n2) {
        return new FloatBufferImpl(fArray, 0, fArray.length, n + n2, n, -1, false);
    }

    public static final FloatBuffer wrap(float[] fArray) {
        return FloatBuffer.wrap(fArray, 0, fArray.length);
    }

    public FloatBuffer get(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            fArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public FloatBuffer get(float[] fArray) {
        return this.get(fArray, 0, fArray.length);
    }

    public FloatBuffer put(FloatBuffer floatBuffer) {
        if (floatBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (floatBuffer.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (floatBuffer.remaining() > 0) {
            float[] fArray = new float[floatBuffer.remaining()];
            floatBuffer.get(fArray);
            floatBuffer.put(fArray);
        }
        return this;
    }

    public FloatBuffer put(float[] fArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(fArray[n3]);
            ++n3;
        }
        return this;
    }

    public final FloatBuffer put(float[] fArray) {
        return this.put(fArray, 0, fArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final float[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof FloatBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        FloatBuffer floatBuffer = (FloatBuffer)object;
        if (floatBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !floatBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = floatBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = (int)(this.get(n2) - floatBuffer.get(n3));
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract float get();

    public abstract FloatBuffer put(float var1);

    public abstract float get(int var1);

    public abstract FloatBuffer put(int var1, float var2);

    public abstract FloatBuffer compact();

    public abstract boolean isDirect();

    public abstract FloatBuffer slice();

    public abstract FloatBuffer duplicate();

    public abstract FloatBuffer asReadOnlyBuffer();
}

