/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Buffer;
import java.nio.BufferOverflowException;
import java.nio.ByteOrder;
import java.nio.LongBufferImpl;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LongBuffer
extends Buffer
implements Comparable {
    int array_offset;
    long[] backing_buffer;

    protected LongBuffer(int n, int n2, int n3, int n4) {
        super(n, n2, n3, n4);
        this.array_offset = 0;
    }

    LongBuffer(long[] lArray, int n, int n2, int n3, int n4, int n5) {
        super(n2, n3, n4, n5);
        this.backing_buffer = lArray;
        this.array_offset = n;
    }

    public static LongBuffer allocate(int n) {
        return new LongBufferImpl(n);
    }

    public static final LongBuffer wrap(long[] lArray, int n, int n2) {
        return new LongBufferImpl(lArray, 0, lArray.length, n + n2, n, -1, false);
    }

    public static final LongBuffer wrap(long[] lArray) {
        return LongBuffer.wrap(lArray, 0, lArray.length);
    }

    public LongBuffer get(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            lArray[n3] = this.get();
            ++n3;
        }
        return this;
    }

    public LongBuffer get(long[] lArray) {
        return this.get(lArray, 0, lArray.length);
    }

    public LongBuffer put(LongBuffer longBuffer) {
        if (longBuffer == this) {
            throw new IllegalArgumentException();
        }
        if (longBuffer.remaining() > this.remaining()) {
            throw new BufferOverflowException();
        }
        if (longBuffer.remaining() > 0) {
            long[] lArray = new long[longBuffer.remaining()];
            longBuffer.get(lArray);
            longBuffer.put(lArray);
        }
        return this;
    }

    public LongBuffer put(long[] lArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            this.put(lArray[n3]);
            ++n3;
        }
        return this;
    }

    public final LongBuffer put(long[] lArray) {
        return this.put(lArray, 0, lArray.length);
    }

    public final boolean hasArray() {
        return this.backing_buffer != null && !this.isReadOnly();
    }

    public final long[] array() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.backing_buffer;
    }

    public final int arrayOffset() {
        if (this.backing_buffer == null) {
            throw new UnsupportedOperationException();
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        return this.array_offset;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LongBuffer) {
            return this.compareTo(object) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(Object object) {
        LongBuffer longBuffer = (LongBuffer)object;
        if (longBuffer.remaining() != this.remaining()) {
            return 1;
        }
        if (!this.hasArray() || !longBuffer.hasArray()) {
            return 1;
        }
        int n = this.remaining();
        int n2 = this.position();
        int n3 = longBuffer.position();
        int n4 = 0;
        while (n4 < n) {
            int n5 = (int)(this.get(n2) - longBuffer.get(n3));
            if (n5 != 0) {
                return n5;
            }
            ++n4;
        }
        return 0;
    }

    public abstract ByteOrder order();

    public abstract long get();

    public abstract LongBuffer put(long var1);

    public abstract long get(int var1);

    public abstract LongBuffer put(int var1, long var2);

    public abstract LongBuffer compact();

    public abstract boolean isDirect();

    public abstract LongBuffer slice();

    public abstract LongBuffer duplicate();

    public abstract LongBuffer asReadOnlyBuffer();
}

