/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LongBufferImpl
extends LongBuffer {
    private boolean readOnly;

    LongBufferImpl(int n) {
        this(new long[n], 0, n, n, 0, -1, false);
    }

    LongBufferImpl(long[] lArray, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(lArray, n, n2, n3, n4, n5);
        this.readOnly = bl;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public LongBuffer slice() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public LongBuffer duplicate() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    @Override
    public LongBuffer asReadOnlyBuffer() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    @Override
    public LongBuffer compact() {
        int n = 0;
        while (this.remaining() > 0) {
            this.put(n, this.get());
            ++n;
        }
        this.position(n);
        return this;
    }

    @Override
    public boolean isDirect() {
        return false;
    }

    @Override
    public final long get() {
        long l = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return l;
    }

    @Override
    public final LongBuffer put(long l) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = l;
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public final long get(int n) {
        return this.backing_buffer[n];
    }

    @Override
    public final LongBuffer put(int n, long l) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[n] = l;
        return this;
    }

    @Override
    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

