/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ShortBuffer;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShortViewBufferImpl
extends ShortBuffer {
    private boolean readOnly;
    private int offset;
    private ByteBuffer bb;
    private ByteOrder endian;

    public ShortViewBufferImpl(ByteBuffer byteBuffer, boolean bl) {
        super(byteBuffer.remaining() >> 1, byteBuffer.remaining() >> 1, byteBuffer.position(), 0);
        this.bb = byteBuffer;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    public ShortViewBufferImpl(ByteBuffer byteBuffer, int n, int n2, int n3, int n4, int n5, boolean bl) {
        super(n3 >> 1, n3 >> 1, n4 >> 1, n5 >> 1);
        this.bb = byteBuffer;
        this.offset = n;
        this.readOnly = bl;
        this.endian = byteBuffer.order();
    }

    @Override
    public short get() {
        short s = this.bb.getShort((this.position() << 1) + this.offset);
        this.position(this.position() + 1);
        return s;
    }

    @Override
    public short get(int n) {
        return this.bb.getShort((n << 1) + this.offset);
    }

    @Override
    public ShortBuffer put(short s) {
        this.bb.putShort((this.position() << 1) + this.offset, s);
        this.position(this.position() + 1);
        return this;
    }

    @Override
    public ShortBuffer put(int n, short s) {
        this.bb.putShort((n << 1) + this.offset, s);
        return this;
    }

    @Override
    public ShortBuffer compact() {
        if (this.position() > 0) {
            int n = this.limit() - this.position();
            int n2 = 0;
            while (n2 < n) {
                this.bb.putShort((n2 >> 1) + this.offset, this.bb.getShort((n2 + this.position() >> 1) + this.offset));
                ++n2;
            }
            this.position(n);
            this.limit(this.capacity());
        }
        return this;
    }

    @Override
    public ShortBuffer duplicate() {
        return new ShortViewBufferImpl(this.bb, this.offset, this.capacity(), this.limit(), this.position(), -1, this.isReadOnly());
    }

    @Override
    public ShortBuffer slice() {
        return new ShortViewBufferImpl(this.bb, (this.position() >> 1) + this.offset, this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    @Override
    public ShortBuffer asReadOnlyBuffer() {
        return new ShortViewBufferImpl(this.bb, (this.position() >> 1) + this.offset, this.remaining(), this.remaining(), 0, -1, true);
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isDirect() {
        return this.bb.isDirect();
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.LITTLE_ENDIAN;
    }
}

