/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.nio.channels.spi.SelectorProvider;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SocketChannel
extends AbstractSelectableChannel
implements ByteChannel,
ScatteringByteChannel,
GatheringByteChannel {
    protected SocketChannel(SelectorProvider selectorProvider) {
        super(selectorProvider);
    }

    public static SocketChannel open() throws IOException {
        return SelectorProvider.provider().openSocketChannel();
    }

    public static SocketChannel open(SocketAddress socketAddress) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        socketChannel.connect(socketAddress);
        return socketChannel;
    }

    @Override
    public final long read(ByteBuffer[] byteBufferArray) throws IOException {
        long l = 0L;
        int n = 0;
        while (n < byteBufferArray.length) {
            l += (long)this.read(byteBufferArray[n]);
            ++n;
        }
        return l;
    }

    @Override
    public final long write(ByteBuffer[] byteBufferArray) throws IOException {
        long l = 0L;
        int n = 0;
        while (n < byteBufferArray.length) {
            l += (long)this.write(byteBufferArray[n]);
            ++n;
        }
        return l;
    }

    @Override
    public final int validOps() {
        return 13;
    }

    @Override
    public abstract int read(ByteBuffer var1) throws IOException;

    public abstract boolean connect(SocketAddress var1) throws IOException;

    public abstract boolean finishConnect() throws IOException;

    public abstract boolean isConnected();

    public abstract boolean isConnectionPending();

    @Override
    public abstract long read(ByteBuffer[] var1, int var2, int var3) throws IOException;

    public abstract Socket socket();

    @Override
    public abstract int write(ByteBuffer var1) throws IOException;

    @Override
    public abstract long write(ByteBuffer[] var1, int var2, int var3) throws IOException;
}

