/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteRef;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteObject
implements Remote,
Serializable {
    private static final long serialVersionUID = -3215090123894869218L;
    protected transient RemoteRef ref;

    protected RemoteObject() {
        this(null);
    }

    protected RemoteObject(RemoteRef remoteRef) {
        this.ref = remoteRef;
    }

    public RemoteRef getRef() {
        return this.ref;
    }

    public static Remote toStub(Remote remote) throws NoSuchObjectException {
        throw new NotImplemented();
    }

    public int hashCode() {
        if (this.ref == null) {
            return 0;
        }
        return this.ref.hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public String toString() {
        return this.ref.toString();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        String string = objectInputStream.readUTF();
        if (!string.equals("")) {
            string = new StringBuffer().append("kaffe.rmi.server.").append(string).toString();
            try {
                Class clazz = Class.forName(string);
                this.ref = (RemoteRef)clazz.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new UnmarshalException("failed to create ref");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnmarshalException("failed to create ref");
            }
            this.ref.readExternal(objectInputStream);
            return;
        }
        this.ref = (RemoteRef)objectInputStream.readObject();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        if (this.ref == null) {
            throw new UnmarshalException("no ref to serialize");
        }
        String string = this.ref.getRefClass(objectOutputStream);
        if (string != null && string.length() > 0) {
            objectOutputStream.writeUTF(string);
            this.ref.writeExternal(objectOutputStream);
            return;
        }
        objectOutputStream.writeUTF("");
        objectOutputStream.writeObject(this.ref);
    }
}

