/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KeyPairGenerator
extends KeyPairGeneratorSpi {
    static final String ENGINE_CLASS = "KeyPairGenerator";
    private final String algorithm;
    private Provider provider;

    protected KeyPairGenerator(String string) {
        this.algorithm = string;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public static KeyPairGenerator getInstance(String string) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(Security.getCryptInstance(ENGINE_CLASS, string));
    }

    public static KeyPairGenerator getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return KeyPairGenerator.getInstance(Security.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static KeyPairGenerator getInstance(Security.Engine engine) {
        KeyPairGenerator keyPairGenerator = (KeyPairGenerator)engine.getEngine();
        keyPairGenerator.provider = engine.getProvider();
        return keyPairGenerator;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void initialize(int n) {
        this.initialize(n, new SecureRandom());
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        throw new UnsupportedOperationException();
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.initialize(algorithmParameterSpec, new SecureRandom());
    }

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    public final KeyPair genKeyPair() {
        return this.generateKeyPair();
    }
}

