/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.provider.DefaultPolicy;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.security.SecurityPermission;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Policy {
    private static Policy currentPolicy = null;
    private Map pd2pc;

    public Policy() {
        this.Block$();
    }

    public static Policy getPolicy() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("getPolicy"));
        }
        return Policy.getCurrentPolicy();
    }

    public static void setPolicy(Policy policy) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission("setPolicy"));
        }
        Policy.setup(policy);
        currentPolicy = policy;
    }

    private static void setup(Policy policy) {
        ProtectionDomain protectionDomain;
        if (policy.pd2pc == null) {
            policy.pd2pc = Collections.synchronizedMap(new HashMap());
        }
        if ((protectionDomain = policy.getClass().getProtectionDomain()).getCodeSource() != null) {
            PermissionCollection permissionCollection = null;
            if (currentPolicy != null) {
                permissionCollection = currentPolicy.getPermissions(protectionDomain);
            }
            if (permissionCollection == null) {
                permissionCollection = new Permissions();
                permissionCollection.add(new AllPermission());
            }
            policy.pd2pc.put(protectionDomain, permissionCollection);
        }
    }

    static Policy getCurrentPolicy() {
        if (currentPolicy == null) {
            String string = System.getProperty("policy.provider");
            if (string != null) {
                try {
                    currentPolicy = (Policy)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (currentPolicy == null) {
                currentPolicy = new DefaultPolicy();
            }
        }
        return currentPolicy;
    }

    static boolean isLoaded() {
        return currentPolicy != null;
    }

    public abstract PermissionCollection getPermissions(CodeSource var1);

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        PermissionCollection permissionCollection;
        PermissionCollection permissionCollection2;
        if (protectionDomain == null) {
            return new Permissions();
        }
        if (this.pd2pc == null) {
            Policy.setup(this);
        }
        if ((permissionCollection2 = (PermissionCollection)this.pd2pc.get(protectionDomain)) != null) {
            Permissions permissions = new Permissions();
            Enumeration enumeration = permissionCollection2.elements();
            while (enumeration.hasMoreElements()) {
                permissions.add((Permission)enumeration.nextElement());
            }
            return permissions;
        }
        permissionCollection2 = this.getPermissions(protectionDomain.getCodeSource());
        if (permissionCollection2 == null) {
            permissionCollection2 = new Permissions();
        }
        if ((permissionCollection = protectionDomain.getPermissions()) != null) {
            Enumeration enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                permissionCollection2.add((Permission)enumeration.nextElement());
            }
        }
        return permissionCollection2;
    }

    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PermissionCollection permissionCollection;
        if (this.pd2pc == null) {
            Policy.setup(this);
        }
        if ((permissionCollection = (PermissionCollection)this.pd2pc.get(protectionDomain)) != null) {
            return permissionCollection.implies(permission);
        }
        boolean bl = false;
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection != null) {
            bl = permissionCollection.implies(permission);
            this.pd2pc.put(protectionDomain, permissionCollection);
        }
        return bl;
    }

    public abstract void refresh();

    private /* synthetic */ void Block$() {
        this.pd2pc = null;
    }
}

