/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecurityPermission;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Security {
    private static final String PROV_PREFIX = "security.provider.";
    private static final String DEF_PROV = "kaffe.security.provider.Kaffe";
    private static final Properties props = new Properties();
    private static final Vector providers = new Vector();

    private Security() {
    }

    public static String getAlgorithmProperty(String string, String string2) {
        String string3 = new StringBuffer().append("Alg.").append(string2).append(".").append(string).toString();
        int n = 0;
        while (n < providers.size()) {
            Provider provider = (Provider)providers.elementAt(n);
            String string4 = provider.getProperty(string3);
            if (string4 != null) {
                return string4;
            }
            ++n;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int insertProviderAt(Provider provider, int n) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(new StringBuffer().append("insertProvider.").append(provider.getName()).toString());
        }
        if (--n < 0) {
            throw new IllegalArgumentException();
        }
        Vector vector = providers;
        synchronized (vector) {
            int n2 = Security.findProvider(provider.getName());
            if (n2 >= 0) {
                return n2 + 1;
            }
            if (n > providers.size()) {
                n = providers.size();
            }
            providers.insertElementAt(provider, n);
        }
        return n + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int addProvider(Provider provider) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(new StringBuffer().append("insertProvider.").append(provider.getName()).toString());
        }
        Vector vector = providers;
        synchronized (vector) {
            if (Security.findProvider(provider.getName()) >= 0) {
                return -1;
            }
            return Security.insertProviderAt(provider, providers.size() + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeProvider(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(new StringBuffer().append("removeProvider.").append(string).toString());
        }
        Vector vector = providers;
        synchronized (vector) {
            int n = Security.findProvider(string);
            if (n >= 0) {
                providers.removeElementAt(n);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Provider[] getProviders() {
        Vector vector = providers;
        synchronized (vector) {
            Provider[] providerArray = new Provider[providers.size()];
            System.arraycopy(providers.toArray(), 0, providerArray, 0, providerArray.length);
            return providerArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Provider getProvider(String string) {
        Vector vector = providers;
        synchronized (vector) {
            int n = Security.findProvider(string);
            return n >= 0 ? (Provider)providers.elementAt(n) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProperty(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission(new StringBuffer().append("getProperty.").append(string).toString()));
        }
        Properties properties = props;
        synchronized (properties) {
            return (String)props.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperty(String string, String string2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SecurityPermission(new StringBuffer().append("setProperty.").append(string).toString()));
        }
        Properties properties = props;
        synchronized (properties) {
            props.put(string, string2);
            return;
        }
    }

    private static int findProvider(String string) {
        int n = 0;
        while (n < providers.size()) {
            Provider provider = (Provider)providers.elementAt(n);
            if (provider.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static Engine getCryptInstance(String string) throws NoSuchAlgorithmException {
        return Security.getCryptInstance(string, null);
    }

    static Engine getCryptInstance(String string, String string2) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            try {
                return Security.getCryptInstance(string, string2, providerArray[n]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
            }
        }
        if (string2 == null) {
            throw new NoSuchAlgorithmException();
        }
        throw new NoSuchAlgorithmException(string2);
    }

    static Engine getCryptInstance(String string, String string2, String string3) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider provider = Security.getProvider(string3);
        if (provider == null) {
            throw new NoSuchProviderException(string3);
        }
        return Security.getCryptInstance(string, string2, provider);
    }

    static Engine getCryptInstance(String string, String string2, Provider provider) throws NoSuchAlgorithmException {
        String string3;
        if (string2 != null && (string3 = (String)provider.get(new StringBuffer().append("Alg.Alias.").append(string).append(".").append(string2).toString())) != null) {
            string2 = string3;
        }
        string3 = null;
        if (string2 != null) {
            string3 = (String)provider.get(new StringBuffer().append(string).append(".").append(string2).toString());
        } else {
            String string4 = new StringBuffer().append(string).append(".").toString();
            Iterator iterator = provider.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string5 = (String)entry.getKey();
                if (!string5.startsWith(string4)) continue;
                string2 = string5.substring(string4.length());
                string3 = (String)entry.getValue();
                break;
            }
        }
        if (string3 == null) {
            throw new NoSuchAlgorithmException(new StringBuffer().append("\"").append(string2).append("\" not supported by provider").toString());
        }
        try {
            return new Engine(provider, string2, Class.forName(string3).newInstance());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoSuchAlgorithmException(new StringBuffer().append("class ").append(string3).append(" not found").toString());
        }
        catch (Exception exception) {
            throw new NoSuchAlgorithmException(new StringBuffer().append("can't instantiate class ").append(string3).append(": ").append(exception).toString());
        }
    }

    static {
        props.put("security.provider.1", DEF_PROV);
        Object object = new File(new StringBuffer().append(System.getProperties().getProperty("java.home")).append("/jre/lib/security/java.security").toString());
        if (((File)object).exists()) {
            try {
                props.load(new BufferedInputStream(new FileInputStream((File)object)));
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = props.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            String string = (String)entry.getKey();
            if (!string.startsWith(PROV_PREFIX)) continue;
            try {
                Security.insertProviderAt((Provider)Class.forName((String)entry.getValue()).newInstance(), Integer.parseInt(string.substring(PROV_PREFIX.length())));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Engine {
        final Provider provider;
        final String algorithm;
        final Object engine;

        Engine(Provider provider, String string, Object object) {
            this.provider = provider;
            this.algorithm = string;
            this.engine = object;
        }

        Provider getProvider() {
            return this.provider;
        }

        String getAlgorithm() {
            return this.algorithm;
        }

        Object getEngine() {
            return this.engine;
        }
    }
}

