/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Signature
extends SignatureSpi {
    static final String ENGINE_CLASS = "Signature";
    protected static final int UNINITIALIZED = 0;
    protected static final int SIGN = 2;
    protected static final int VERIFY = 3;
    protected int state;
    private final String algorithm;
    private Provider provider;
    private SignatureSpi engine;
    private static String NONSPI_MSG = "This Signature is not a SignatureSpi. SignatureSpi methods should not be used on Signature objects.";

    protected Signature(String string) {
        this.Block$();
        this.algorithm = string;
    }

    public static Signature getInstance(String string) throws NoSuchAlgorithmException {
        return Signature.getInstance(Security.getCryptInstance(ENGINE_CLASS, string));
    }

    public static Signature getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        return Signature.getInstance(Security.getCryptInstance(ENGINE_CLASS, string, string2));
    }

    private static Signature getInstance(Security.Engine engine) {
        Signature signature = null;
        Object object = engine.getEngine();
        if (object instanceof Signature) {
            signature = (Signature)object;
            signature.state = 0;
        } else {
            signature = new NonSpiSignature(engine.algorithm);
            signature.engine = (SignatureSpi)object;
        }
        signature.provider = engine.getProvider();
        return signature;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void initVerify(PublicKey publicKey) throws InvalidKeyException {
        this.engine.engineInitVerify(publicKey);
    }

    public final void initSign(PrivateKey privateKey) throws InvalidKeyException {
        this.engine.engineInitSign(privateKey);
    }

    public final void initSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        this.engine.engineInitSign(privateKey, secureRandom);
    }

    public final byte[] sign() throws SignatureException {
        return this.engine.engineSign();
    }

    public final int sign(byte[] byArray, int n, int n2) throws SignatureException {
        byte[] byArray2 = this.sign();
        if (n2 < byArray2.length) {
            throw new SignatureException();
        }
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    public final boolean verify(byte[] byArray) throws SignatureException {
        return this.engine.engineVerify(byArray);
    }

    public final void update(byte by) throws SignatureException {
        this.engine.engineUpdate(by);
    }

    public final void update(byte[] byArray) throws SignatureException {
        this.engine.engineUpdate(byArray, 0, byArray.length);
    }

    public final void update(byte[] byArray, int n, int n2) throws SignatureException {
        this.engine.engineUpdate(byArray, n, n2);
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public String toString() {
        return super.toString();
    }

    public final void setParameter(String string, Object object) throws InvalidParameterException {
        this.engine.engineSetParameter(string, object);
    }

    public final void setParameter(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
        this.engine.engineSetParameter(algorithmParameterSpec);
    }

    public final Object getParameter(String string) throws InvalidParameterException {
        return this.engine.engineGetParameter(string);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    private /* synthetic */ void Block$() {
        this.engine = this;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NonSpiSignature
    extends Signature {
        protected NonSpiSignature(String string) {
            super(string);
        }

        @Override
        protected Object engineGetParameter(String string) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        protected AlgorithmParameters engineGetParameters() {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineInitVerify(PublicKey publicKey) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineSetParameter(String string, Object object) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected byte[] engineSign() {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected int engineSign(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineUpdate(byte by) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        @Override
        protected boolean engineVerify(byte[] byArray) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }

        protected boolean engineVerify(byte[] byArray, int n, int n2) {
            throw new UnsupportedOperationException(NONSPI_MSG);
        }
    }
}

