/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509Extension;
import java.util.Date;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class X509CRLEntry
implements X509Extension {
    public abstract byte[] getEncoded() throws CRLException;

    public abstract BigInteger getSerialNumber();

    public abstract Date getRevocationDate();

    public abstract boolean hasExtensions();

    public abstract String toString();

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof X509CRLEntry) {
            X509CRLEntry x509CRLEntry = (X509CRLEntry)object;
            try {
                byte[] byArray = x509CRLEntry.getEncoded();
                byte[] byArray2 = this.getEncoded();
                if (byArray != null && byArray2 != null && byArray.length == byArray2.length) {
                    bl = true;
                    int n = 0;
                    while (n < byArray.length && bl) {
                        if (byArray[n] != byArray2[n]) {
                            bl = false;
                        }
                        ++n;
                    }
                }
            }
            catch (CRLException cRLException) {
                // empty catch block
            }
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        try {
            byte[] byArray = this.getEncoded();
            if (byArray != null) {
                switch (byArray.length) {
                    case 1: {
                        n = byArray[0];
                        break;
                    }
                    case 2: {
                        n = byArray[0] << 8 | byArray[1];
                        break;
                    }
                    case 3: {
                        n = byArray[0] << 16 | byArray[1] << 8 | byArray[2];
                        break;
                    }
                    default: {
                        n = byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3];
                        break;
                    }
                }
            }
        }
        catch (CRLException cRLException) {
            // empty catch block
        }
        return n;
    }
}

