/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.Annotation;
import java.text.AttributedCharacterIterator;
import java.text.AttributedStringIterator;
import java.text.StringCharacterIterator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributedString {
    private StringCharacterIterator sci;
    private AttributeRange[] attribs;

    public AttributedString(String string) {
        this.sci = new StringCharacterIterator(string);
        this.attribs = new AttributeRange[0];
    }

    public AttributedString(String string, Map map) {
        this(string);
        this.attribs = new AttributeRange[1];
        this.attribs[0] = new AttributeRange(map, 0, string.length());
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator) {
        this(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex(), attributedCharacterIterator.getEndIndex(), null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this(attributedCharacterIterator, n, n2, null);
    }

    public AttributedString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        Object object;
        Iterator iterator;
        if (n < 0 || n2 < n) {
            throw new IllegalArgumentException("Bad index values");
        }
        StringBuffer stringBuffer = new StringBuffer("");
        Set set = attributedCharacterIterator.getAllAttributeKeys();
        if (attributeArray != null) {
            HashSet hashSet = new HashSet();
            iterator = set.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                int n3 = 0;
                while (n3 < attributeArray.length) {
                    if (object.equals(attributeArray[0])) break;
                    ++n3;
                }
                if (n3 == attributeArray.length) continue;
                hashSet.add(object);
            }
            set = hashSet;
        }
        char c = attributedCharacterIterator.setIndex(n);
        do {
            stringBuffer.append(c);
            iterator = set.iterator();
            while (iterator.hasNext()) {
                AttributedCharacterIterator.Attribute attribute;
                int n4;
                object = iterator.next();
                if (!(object instanceof AttributedCharacterIterator.Attribute) || (n4 = attributedCharacterIterator.getRunLimit(attribute = (AttributedCharacterIterator.Attribute)object)) == -1) continue;
                if (n4 > n2) {
                    n4 = n2;
                }
                n4 -= n;
                int n5 = attributedCharacterIterator.getRunStart(attribute);
                if (n5 < attributedCharacterIterator.getIndex() && attributedCharacterIterator.getIndex() != n) continue;
                Object object2 = attributedCharacterIterator.getAttribute(attribute);
                if (n5 < n) {
                    if (object2 instanceof Annotation) continue;
                    n5 = n;
                } else {
                    n5 -= n;
                }
                Hashtable hashtable = new Hashtable();
                hashtable.put(attribute, object2);
                AttributeRange[] attributeRangeArray = new AttributeRange[this.attribs.length + 1];
                System.arraycopy(this.attribs, 0, attributeRangeArray, 0, this.attribs.length);
                this.attribs = attributeRangeArray;
                this.attribs[this.attribs.length - 1] = new AttributeRange(hashtable, n5, n4);
            }
        } while ((c = attributedCharacterIterator.next()) != '\uffff');
        this.sci = new StringCharacterIterator(stringBuffer.toString());
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object) {
        this.addAttribute(attribute, object, 0, this.sci.getEndIndex() - 1);
    }

    public void addAttribute(AttributedCharacterIterator.Attribute attribute, Object object, int n, int n2) {
        if (attribute == null) {
            throw new IllegalArgumentException("null attribute");
        }
        Hashtable hashtable = new Hashtable();
        hashtable.put(attribute, object);
        this.addAttributes(hashtable, n, n2);
    }

    public void addAttributes(Map map, int n, int n2) {
        if (map == null) {
            throw new IllegalArgumentException("null attribute");
        }
        if (n < 0 || n2 > this.sci.getEndIndex() || n2 < n) {
            throw new IllegalArgumentException("bad range");
        }
        AttributeRange[] attributeRangeArray = new AttributeRange[this.attribs.length + 1];
        System.arraycopy(this.attribs, 0, attributeRangeArray, 0, this.attribs.length);
        this.attribs = attributeRangeArray;
        this.attribs[this.attribs.length - 1] = new AttributeRange(map, n, n2);
    }

    public AttributedCharacterIterator getIterator() {
        return new AttributedStringIterator(this.sci, this.attribs, 0, this.sci.getEndIndex() - 1, null);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray) {
        return this.getIterator(attributeArray, 0, this.sci.getEndIndex() - 1);
    }

    public AttributedCharacterIterator getIterator(AttributedCharacterIterator.Attribute[] attributeArray, int n, int n2) {
        if (n < 0 || n2 > this.sci.getEndIndex() || n2 < n) {
            throw new IllegalArgumentException("bad range");
        }
        return new AttributedStringIterator(this.sci, this.attribs, n, n2, attributeArray);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class AttributeRange {
        Map attribs;
        int begin_index;
        int end_index;

        AttributeRange(Map map, int n, int n2) {
            this.attribs = map;
            this.begin_index = n;
            this.end_index = n2;
        }
    }
}

