/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.Serializable;
import java.text.Format;
import java.util.Locale;
import java.util.ResourceBundle;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateFormatSymbols
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -5987973545549424702L;
    String[] amPmStrings;
    String[] eras;
    String localPatternChars;
    String[] months;
    String[] shortMonths;
    String[] shortWeekdays;
    String[] weekdays;
    String[][] zoneStrings;

    public DateFormatSymbols() {
        this(Locale.getDefault());
    }

    public DateFormatSymbols(Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("dateformat", locale2);
        this.amPmStrings = (String[])resourceBundle.getObject("amPmStrings");
        this.eras = (String[])resourceBundle.getObject("eras");
        this.localPatternChars = resourceBundle.getString("localPatternChars");
        this.months = (String[])resourceBundle.getObject("months");
        this.shortMonths = (String[])resourceBundle.getObject("shortMonths");
        this.shortWeekdays = (String[])resourceBundle.getObject("shortWeekdays");
        this.weekdays = (String[])resourceBundle.getObject("weekdays");
        this.zoneStrings = (String[][])resourceBundle.getObject("zoneStrings");
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DateFormatSymbols) {
            DateFormatSymbols dateFormatSymbols = (DateFormatSymbols)object;
            if (!this.localPatternChars.equals(dateFormatSymbols.localPatternChars)) {
                return false;
            }
            int n = this.eras.length;
            while (n-- > 0) {
                if (this.eras[n].equals(dateFormatSymbols.eras[n])) continue;
                return false;
            }
            n = this.amPmStrings.length;
            while (n-- > 0) {
                if (this.amPmStrings[n].equals(dateFormatSymbols.amPmStrings[n])) continue;
                return false;
            }
            n = this.months.length;
            while (n-- > 0) {
                if (this.months[n].equals(dateFormatSymbols.months[n])) continue;
                return false;
            }
            n = this.shortMonths.length;
            while (n-- > 0) {
                if (this.shortMonths[n].equals(dateFormatSymbols.shortMonths[n])) continue;
                return false;
            }
            n = this.weekdays.length;
            while (n-- > 0) {
                if (this.weekdays[n].equals(dateFormatSymbols.weekdays[n])) continue;
                return false;
            }
            n = this.shortWeekdays.length;
            while (n-- > 0) {
                if (this.shortWeekdays[n].equals(dateFormatSymbols.shortWeekdays[n])) continue;
                return false;
            }
            n = this.zoneStrings.length;
            while (n-- > 0) {
                int n2 = this.zoneStrings[n].length;
                while (n2-- > 0) {
                    if (this.zoneStrings[n][n2].equals(dateFormatSymbols.zoneStrings[n][n2])) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public String[] getAmPmStrings() {
        return this.amPmStrings;
    }

    public String[] getEras() {
        return this.eras;
    }

    public String getLocalPatternChars() {
        return this.localPatternChars;
    }

    public String[] getMonths() {
        return this.months;
    }

    public String[] getShortMonths() {
        return this.shortMonths;
    }

    public String[] getShortWeekdays() {
        return this.shortWeekdays;
    }

    public String[] getWeekdays() {
        return this.weekdays;
    }

    public String[][] getZoneStrings() {
        return this.zoneStrings;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void setAmPmStrings(String[] stringArray) {
        this.amPmStrings = stringArray;
    }

    public void setEras(String[] stringArray) {
        this.eras = stringArray;
    }

    public void setLocalPatternChars(String string) {
        this.localPatternChars = string;
    }

    public void setMonths(String[] stringArray) {
        this.months = stringArray;
    }

    public void setShortMonths(String[] stringArray) {
        this.shortMonths = stringArray;
    }

    public void setShortWeekdays(String[] stringArray) {
        this.shortWeekdays = stringArray;
    }

    public void setWeekdays(String[] stringArray) {
        this.weekdays = stringArray;
    }

    public void setZoneStrings(String[][] stringArray) {
        this.zoneStrings = stringArray;
    }
}

