/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import kaffe.util.NotImplemented;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecimalFormat
extends NumberFormat {
    private static final long serialVersionUID = 864413376551465018L;
    private DecimalFormatSymbols syms;
    private int groupsize;
    private int multiplier;
    private String negativeprefix;
    private String negativesuffix;
    private String positiveprefix;
    private String positivesuffix;
    private boolean decsepshown;
    private int expo_numcount;
    private int expoint;

    public DecimalFormat() {
        this("#,##0.###;-#,##0.###", Locale.getDefault());
    }

    public DecimalFormat(String string) {
        this(string, Locale.getDefault());
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.syms = decimalFormatSymbols;
        this.applyPattern(string);
    }

    DecimalFormat(String string, Locale locale2) {
        this(string, new DecimalFormatSymbols(locale2));
    }

    public void applyLocalizedPattern(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == this.syms.digit) {
                cArray[n] = 35;
            } else if (cArray[n] == this.syms.patternSeparator) {
                cArray[n] = 59;
            } else if (cArray[n] == this.syms.zeroDigit) {
                cArray[n] = 48;
            } else if (cArray[n] == this.syms.groupSeparator) {
                cArray[n] = 44;
            } else if (cArray[n] == this.syms.decimalSeparator) {
                cArray[n] = 46;
            } else if (cArray[n] == this.syms.percentSign) {
                cArray[n] = 37;
            } else if (cArray[n] == this.syms.permillSign) {
                cArray[n] = 8240;
            } else if (cArray[n] == this.syms.currencySign) {
                cArray[n] = 164;
            } else if (cArray[n] == this.syms.minusSign) {
                cArray[n] = 45;
            } else if (cArray[n] == '\'') {
                ++n;
                while (n < cArray.length && cArray[n] != '\'') {
                    ++n;
                }
            }
            ++n;
        }
        this.applyPattern(new String(cArray));
    }

    public void applyPattern(String string) {
        this.multiplier = 100;
        this.negativeprefix = "";
        this.negativesuffix = "";
        this.positiveprefix = "";
        this.positivesuffix = "";
        this.intonly = true;
        this.minint = 1;
        this.maxint = Integer.MAX_VALUE;
        this.minfrac = 0;
        this.maxfrac = 0;
        this.decsepshown = false;
        this.groupsize = Integer.MAX_VALUE;
        this.grouping = false;
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < cArray.length) {
            block0 : switch (cArray[n5]) {
                case '#': 
                case ',': 
                case '.': 
                case '0': 
                case 'E': {
                    switch (n3) {
                        case 0: {
                            this.positiveprefix = new String(cArray, n4, n5 - n4);
                            n3 = 1;
                            n = n5;
                            break;
                        }
                        case 2: {
                            this.positivesuffix = new String(cArray, n4, n5 - n4);
                            n3 = 3;
                            break;
                        }
                        case 4: {
                            this.negativeprefix = new String(cArray, n4, n5 - n4);
                            n3 = 5;
                            break;
                        }
                        case 6: {
                            this.negativesuffix = new String(cArray, n4, n5 - n4);
                            n3 = 7;
                        }
                    }
                    break;
                }
                case ';': {
                    if (n3 == 2) {
                        this.positivesuffix = new String(cArray, n4, n5 - n4);
                    }
                    n4 = n5 + 1;
                    n2 = n5;
                    n3 = 4;
                    break;
                }
                default: {
                    switch (n3) {
                        case 1: {
                            n4 = n5;
                            n3 = 2;
                            break block0;
                        }
                        case 5: {
                            n4 = n5;
                            n3 = 6;
                        }
                    }
                }
            }
            ++n5;
        }
        if (n3 == 6) {
            this.negativesuffix = new String(cArray, n4, cArray.length - n4);
        }
        if (this.positiveprefix.equals(this.negativeprefix) && this.positivesuffix.equals(this.negativesuffix)) {
            char[] cArray2 = new char[]{this.syms.minusSign};
            this.negativeprefix = new String(cArray2);
        }
        boolean bl = false;
        boolean bl2 = false;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        this.expo_numcount = 0;
        int n9 = n;
        while (n9 < n2) {
            switch (cArray[n9]) {
                case '0': {
                    if (n8 > 0 && bl && !bl2) {
                        throw new IllegalArgumentException(new StringBuffer().append("illegal pattern \"").append(string).append("\"").toString());
                    }
                    if (bl2) {
                        ++this.expo_numcount;
                        break;
                    }
                    ++n7;
                    break;
                }
                case '#': {
                    if (n7 > 0 && !bl) {
                        throw new IllegalArgumentException(new StringBuffer().append("illegal pattern \"").append(string).append("\"").toString());
                    }
                    ++n8;
                    break;
                }
                case '.': {
                    if (bl || bl2) {
                        throw new IllegalArgumentException(new StringBuffer().append("illegal pattern \"").append(string).append("\"").toString());
                    }
                    bl = true;
                    this.minint = n7;
                    if (n8 == 0) {
                        n8 = 1;
                    }
                    this.expoint = n8;
                    this.maxint = Integer.MAX_VALUE;
                    if (n6 == -1 || n9 - n6 < 2) {
                        this.groupsize = 0;
                        this.grouping = false;
                    } else {
                        this.groupsize = n9 - n6 - 1;
                        this.grouping = true;
                    }
                    n8 = 0;
                    n7 = 0;
                    break;
                }
                case ',': {
                    if (n6 >= 0) {
                        throw new IllegalArgumentException(new StringBuffer().append("illegal pattern \"").append(string).append("\"").toString());
                    }
                    n6 = n9;
                    break;
                }
                case 'E': {
                    if (n6 >= 0 || this.grouping || bl2) {
                        throw new IllegalArgumentException(new StringBuffer().append("illegal pattern \"").append(string).append("\"").toString());
                    }
                    bl2 = true;
                }
            }
            ++n9;
        }
        if (bl2 && this.expo_numcount == 0) {
            throw new IllegalArgumentException(new StringBuffer().append("illegal pattern \"").append(string).append("\"").toString());
        }
        if (bl) {
            this.intonly = false;
            this.minfrac = n7;
            this.maxfrac = this.minfrac + n8;
            if (n7 > 0) {
                this.decsepshown = true;
                return;
            }
        } else {
            this.minint = n7;
        }
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    private StringBuffer format(String string, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        StringBuffer stringBuffer2 = new StringBuffer();
        char[] cArray = string.toCharArray();
        int n = string.indexOf(46);
        int n2 = n;
        if (n2 == -1) {
            n2 = cArray.length;
        } else if (this.maxfrac == 0) {
            if (cArray[n + 1] >= '5') {
                cArray[n - 1] = (char)(cArray[n - 1] + '\u0001' - 48 + this.syms.zeroDigit);
            }
        } else if (this.maxfrac < cArray.length - n - 1 && cArray[n + this.maxfrac + 1] >= '5') {
            cArray[n + this.maxfrac] = (char)(cArray[n + this.maxfrac] + '\u0001' - 48 + this.syms.zeroDigit);
        }
        int n3 = 0;
        if (cArray[n3] == '-') {
            ++n3;
        }
        int n4 = 0;
        int n5 = n2 - 1;
        while (n5 >= n3 && n4 < this.maxint) {
            if (this.grouping && n4 % this.groupsize == 0 && n4 > 0) {
                stringBuffer2.append(this.syms.groupSeparator);
            }
            stringBuffer2.append((char)(cArray[n5] - 48 + this.syms.zeroDigit));
            --n5;
            ++n4;
        }
        while (n4 < this.minint) {
            if (this.grouping && n4 % this.groupsize == 0) {
                stringBuffer2.append(this.syms.groupSeparator);
            }
            stringBuffer2.append(this.syms.zeroDigit);
            ++n4;
        }
        stringBuffer2.reverse();
        if (cArray[0] == '-') {
            stringBuffer2.insert(0, this.negativeprefix);
        } else {
            stringBuffer2.insert(0, this.positiveprefix);
        }
        if (fieldPosition.getField() == 0) {
            fieldPosition.setBeginIndex(stringBuffer.length());
            stringBuffer.append(stringBuffer2);
            fieldPosition.setEndIndex(stringBuffer.length());
        } else {
            stringBuffer.append(stringBuffer2);
        }
        stringBuffer2.setLength(0);
        if (!this.intonly) {
            n4 = 0;
            if (n != -1) {
                n3 = n + 1;
                n2 = cArray.length;
                if (cArray[n2 - 1] == '0') {
                    --n2;
                }
                n5 = n3;
                while (n5 < n2 && n4 < this.maxfrac) {
                    stringBuffer2.append((char)(cArray[n5] - 48 + this.syms.zeroDigit));
                    ++n5;
                    ++n4;
                }
            }
            while (n4 < this.minfrac) {
                stringBuffer2.append(this.syms.zeroDigit);
                ++n4;
            }
            if (n4 == 0) {
                n = -1;
            }
        }
        if (cArray[0] == '-') {
            stringBuffer2.append(this.negativesuffix);
        } else {
            stringBuffer2.append(this.positivesuffix);
        }
        if (this.decsepshown || !this.intonly && (n != -1 || this.minfrac > 0)) {
            stringBuffer.append(this.syms.decimalSeparator);
        }
        if (fieldPosition.getField() == 1) {
            fieldPosition.setBeginIndex(stringBuffer.length());
            stringBuffer.append(stringBuffer2);
            fieldPosition.setEndIndex(stringBuffer.length());
        } else {
            stringBuffer.append(stringBuffer2);
        }
        return stringBuffer;
    }

    @Override
    public StringBuffer format(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.expo_numcount == 0) {
            return this.format(Double.toString(d), stringBuffer, fieldPosition);
        }
        return this.formatExponential(d, stringBuffer, fieldPosition);
    }

    public StringBuffer formatExponential(double d, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        double d2 = Math.abs(d);
        if (d2 == 0.0) {
            StringBuffer stringBuffer2 = this.format(Double.toString(d), stringBuffer, fieldPosition);
            stringBuffer2.append("E");
            int n = 0;
            while (n < this.expo_numcount) {
                stringBuffer2.append("0");
                ++n;
            }
            return stringBuffer2;
        }
        int n = (int)Math.floor(Math.log(d2) / Math.log(10.0));
        int n2 = (int)Math.floor((double)n / (double)this.expoint) * this.expoint;
        StringBuffer stringBuffer3 = this.format(Double.toString(d *= Math.pow(10.0, -n2)), stringBuffer, fieldPosition);
        String string = Integer.toString(n2);
        stringBuffer3.append("E");
        int n3 = string.length();
        while (n3 < this.expo_numcount) {
            stringBuffer3.append("0");
            ++n3;
        }
        stringBuffer3.append(string);
        return stringBuffer3;
    }

    @Override
    public StringBuffer format(long l, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (this.expo_numcount == 0) {
            return this.format(Long.toString(l), stringBuffer, fieldPosition);
        }
        return this.format((double)l, stringBuffer, fieldPosition);
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.syms;
    }

    public int getGroupingSize() {
        return this.groupsize;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public String getNegativePrefix() {
        return this.negativeprefix;
    }

    public String getNegativeSuffix() {
        return this.negativesuffix;
    }

    public String getPositivePrefix() {
        return this.positiveprefix;
    }

    public String getPositiveSuffix() {
        return this.positivesuffix;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decsepshown;
    }

    @Override
    public Number parse(String string, ParsePosition parsePosition) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = parsePosition.getIndex();
        int n2 = this.parse0(string, n, string.length(), stringBuffer, false);
        if (n2 < 0) {
            parsePosition.setErrorIndex(-n2);
            return null;
        }
        parsePosition.setIndex(n2);
        try {
            return Long.valueOf(stringBuffer.toString());
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return Double.valueOf(stringBuffer.toString());
            }
            catch (NumberFormatException numberFormatException2) {
                parsePosition.setIndex(n);
                parsePosition.setErrorIndex(n2);
                return null;
            }
        }
    }

    private int parse0(String string, int n, int n2, StringBuffer stringBuffer, boolean bl) {
        if (!bl && !this.isParseIntegerOnly() && string.regionMatches(false, n, this.syms.nan, 0, this.syms.nan.length())) {
            stringBuffer.append("NaN");
            return n + this.syms.nan.length();
        }
        if (this.positiveprefix.length() > 0 && string.regionMatches(false, n, this.positiveprefix, 0, this.positiveprefix.length())) {
            n += this.positiveprefix.length();
        } else if (this.negativeprefix.length() > 0 && string.regionMatches(false, n, this.negativeprefix, 0, this.negativeprefix.length())) {
            stringBuffer.append('-');
            n += this.negativeprefix.length();
        }
        if (!bl && !this.isParseIntegerOnly() && string.regionMatches(false, n, this.syms.infinity, 0, this.syms.infinity.length())) {
            stringBuffer.append("Inf");
            n += this.syms.infinity.length();
        }
        boolean bl2 = !bl && !this.isParseIntegerOnly();
        char c = this.syms.zeroDigit;
        char c2 = (char)(c + 9);
        while (n < n2) {
            char c3 = string.charAt(n);
            if (c <= c3 && c3 <= c2) {
                stringBuffer.append((char)(c3 - c + 48));
                ++n;
                continue;
            }
            if (c3 == this.syms.decimalSeparator && bl2) {
                bl2 = false;
                stringBuffer.append('.');
                ++n;
                continue;
            }
            if (c3 == this.syms.groupSeparator && this.isGroupingUsed() && !bl) {
                ++n;
                continue;
            }
            if (c3 != 'E' || bl) break;
            stringBuffer.append('E');
            n = this.parse0(string, n + 1, n2, stringBuffer, true);
            if (n >= 0) continue;
            return n;
        }
        return n;
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        this.syms = decimalFormatSymbols;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl) {
        this.decsepshown = bl;
    }

    public void setGroupingSize(int n) {
        this.groupsize = n;
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public void setNegativePrefix(String string) {
        this.negativeprefix = string;
    }

    public void setNegativeSuffix(String string) {
        this.negativesuffix = string;
    }

    public void setPositivePrefix(String string) {
        this.positiveprefix = string;
    }

    public void setPositiveSuffix(String string) {
        this.positivesuffix = string;
    }

    public String toLocalizedPattern() {
        throw new NotImplemented();
    }

    public String toPattern() {
        throw new NotImplemented();
    }
}

