/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleDateFormat
extends DateFormat {
    private static final long serialVersionUID = 4774881970558875024L;
    private static final String DEFAULTPATTERNCHARS = "GyMdkHmsSEDFwWahKz";
    private DateFormatSymbols syms;
    private String pattern;
    private static String NUMERIC_PATTERN = "ydhHmsSDFwWkK";
    private static int[] NUMERIC_FIELD = new int[]{Calendar.MONTH, Calendar.YEAR, Calendar.DAY_OF_MONTH, Calendar.HOUR, Calendar.HOUR_OF_DAY, Calendar.MINUTE, Calendar.SECOND, Calendar.MILLISECOND, Calendar.DAY_OF_YEAR, Calendar.DAY_OF_WEEK_IN_MONTH, Calendar.WEEK_OF_YEAR, Calendar.DAY_OF_WEEK_IN_MONTH, Calendar.HOUR_OF_DAY, Calendar.HOUR};

    private static String getDefaultPattern(Locale locale2) {
        ResourceBundle resourceBundle = Format.getResources("dateformat", locale2);
        String string = ((String[])resourceBundle.getObject("date"))[2];
        String string2 = ((String[])resourceBundle.getObject("time"))[2];
        return new StringBuffer().append(string).append(" ").append(string2).toString();
    }

    public SimpleDateFormat() {
        this(SimpleDateFormat.getDefaultPattern(Locale.getDefault()), Locale.getDefault());
    }

    public SimpleDateFormat(String string) {
        this(string, Locale.getDefault());
    }

    public SimpleDateFormat(String string, DateFormatSymbols dateFormatSymbols) {
        this.syms = dateFormatSymbols;
        this.pattern = string;
        this.calendar = new GregorianCalendar();
        this.numberFormat = new DecimalFormat("0");
    }

    public SimpleDateFormat(String string, Locale locale2) {
        this.syms = new DateFormatSymbols(locale2);
        this.pattern = string;
        this.calendar = new GregorianCalendar(locale2);
        this.numberFormat = new DecimalFormat("0", locale2);
    }

    public void applyLocalizedPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.syms.getLocalPatternChars();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = string2.indexOf(c);
            if (n2 >= 0) {
                stringBuffer.append(DEFAULTPATTERNCHARS.charAt(n2));
            } else {
                stringBuffer.append(c);
                if (c == '\'') {
                    do {
                        c = string.charAt(++n);
                        stringBuffer.append(c);
                    } while (c != '\'');
                }
            }
            ++n;
        }
        this.pattern = stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.pattern = string;
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)object;
            if (this.numberFormat.equals(simpleDateFormat.numberFormat) && this.syms.equals(simpleDateFormat.syms)) {
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public StringBuffer format(Date date, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        this.calendar.setTime(date);
        char[] cArray = this.pattern.toCharArray();
        int n = 0;
        block24: while (n < cArray.length) {
            int n2 = 0;
            char c = cArray[n];
            ++n;
            if (c != '\'') {
                ++n2;
                while (n < cArray.length && cArray[n] == c) {
                    ++n2;
                    ++n;
                }
            }
            int n3 = stringBuffer.length();
            switch (c) {
                case 'G': {
                    int n4 = this.calendar.get(0);
                    stringBuffer.append(this.syms.eras[n4]);
                    if (fieldPosition.getField() != 0) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'y': {
                    int n4 = this.calendar.get(1);
                    if (n2 < 4 && (n4 %= 100) < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 1) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'M': {
                    int n4 = this.calendar.get(2);
                    if (n2 < 3) {
                        if (++n4 < 10 && n2 == 2) {
                            stringBuffer.append('0');
                        }
                        stringBuffer.append(n4);
                    } else if (n2 == 3) {
                        stringBuffer.append(this.syms.shortMonths[n4]);
                    } else {
                        stringBuffer.append(this.syms.months[n4]);
                    }
                    if (fieldPosition.getField() != 2) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'd': {
                    int n4 = this.calendar.get(5);
                    if (n2 > 1 && n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 3) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'k': {
                    int n4 = this.calendar.get(11);
                    if (n4 == 0) {
                        n4 = 24;
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 4) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'H': {
                    int n4 = this.calendar.get(11);
                    if (n2 > 1 && n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 5) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'm': {
                    int n4 = this.calendar.get(12);
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 6) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 's': {
                    int n4 = this.calendar.get(13);
                    if (n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 7) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'S': {
                    int n4 = this.calendar.get(14);
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 8) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'E': {
                    int n4 = this.calendar.get(7);
                    if (n2 < 4) {
                        stringBuffer.append(this.syms.shortWeekdays[n4]);
                    } else {
                        stringBuffer.append(this.syms.weekdays[n4]);
                    }
                    if (fieldPosition.getField() != 9) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'D': {
                    int n4 = this.calendar.get(6);
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 10) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'F': {
                    int n4 = this.calendar.get(8);
                    stringBuffer.append(n4);
                    break;
                }
                case 'w': {
                    int n4 = this.calendar.get(3);
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 12) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'W': {
                    int n4 = this.calendar.get(4);
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 13) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'a': {
                    int n4 = this.calendar.get(9);
                    stringBuffer.append(this.syms.amPmStrings[n4]);
                    if (fieldPosition.getField() != 14) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'h': {
                    int n4 = this.calendar.get(10);
                    if (n4 == 0) {
                        n4 = 12;
                    }
                    if (n2 > 1 && n4 < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 15) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'K': {
                    int n4 = this.calendar.get(10);
                    stringBuffer.append(n4);
                    if (fieldPosition.getField() != 16) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case 'z': {
                    TimeZone timeZone = this.calendar.getTimeZone();
                    String string = timeZone.getID();
                    boolean bl = timeZone.inDaylightTime(date);
                    int n5 = 0;
                    while (n5 < this.syms.zoneStrings.length) {
                        String[] stringArray = this.syms.zoneStrings[n5];
                        if (string.equals(stringArray[0])) {
                            if (n2 < 4) {
                                if (bl) {
                                    stringBuffer.append(stringArray[4]);
                                    break;
                                }
                                stringBuffer.append(stringArray[2]);
                                break;
                            }
                            if (bl) {
                                stringBuffer.append(stringArray[3]);
                                break;
                            }
                            stringBuffer.append(stringArray[1]);
                            break;
                        }
                        ++n5;
                    }
                    if (n5 == this.syms.zoneStrings.length) {
                        stringBuffer.append("GMT");
                        int n6 = timeZone.getOffset(this.calendar.get(0), this.calendar.get(1), this.calendar.get(2), this.calendar.get(5), this.calendar.get(7), this.calendar.get(14)) / 60000;
                        if (n6 < 0) {
                            n6 = Math.abs(n6);
                            stringBuffer.append("-");
                        } else if (n6 > 0) {
                            stringBuffer.append("+");
                        }
                        if (n6 != 0) {
                            stringBuffer.append(n6 / 60);
                            stringBuffer.append(":");
                            if (n6 % 60 < 10) {
                                stringBuffer.append("0");
                            }
                            stringBuffer.append(n6 % 60);
                        }
                    }
                    if (fieldPosition.getField() != 17) continue block24;
                    fieldPosition.setBeginIndex(n3);
                    fieldPosition.setEndIndex(stringBuffer.length());
                    break;
                }
                case '\'': {
                    if (cArray[n] == '\'') {
                        stringBuffer.append('\'');
                        ++n;
                        break;
                    }
                    boolean bl = false;
                    while (!bl && n < cArray.length) {
                        switch (cArray[n]) {
                            case '\'': {
                                if (n + 1 < cArray.length && cArray[n + 1] == '\'') {
                                    stringBuffer.append('\'');
                                    ++n;
                                    break;
                                }
                                bl = true;
                                break;
                            }
                            default: {
                                stringBuffer.append(cArray[n]);
                            }
                        }
                        ++n;
                    }
                    continue block24;
                }
                default: {
                    int n5 = 0;
                    while (n5 < n2) {
                        stringBuffer.append(c);
                        ++n5;
                    }
                    continue block24;
                }
            }
        }
        return stringBuffer;
    }

    public DateFormatSymbols getDateFormatSymbols() {
        return this.syms;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Date parse(String var1_1, ParsePosition var2_2) {
        this.calendar.clear();
        this.numberFormat.setParseIntegerOnly(true);
        this.numberFormat.setGroupingUsed(false);
        var2_2.setErrorIndex(-1);
        var4_4 = var3_3 = var2_2.getIndex();
        var5_5 = var1_1.length();
        var6_6 = -1;
        var7_7 = -1;
        var8_8 = this.pattern.toCharArray();
        var9_9 = 0;
        while (var9_9 < var8_8.length) {
            block40: {
                if ((var10_10 = var8_8[var9_9++]) != '\'') break block40;
                if (var9_9 < var8_8.length && var8_8[var9_9] == '\'') {
                    if (var4_4 >= var5_5 || var1_1.charAt(var4_4) != '\'') {
                        var2_2.setIndex(var3_3);
                        var2_2.setErrorIndex(var4_4);
                        return null;
                    }
                    ++var4_4;
                    ++var9_9;
                    continue;
                }
                var11_11 = 0;
                var12_12 = 0;
                while (var11_11 == 0 && var12_12 == 0 && var9_9 < var8_8.length && var4_4 < var5_5) {
                    switch (var8_8[var9_9]) {
                        case '\'': {
                            if (var9_9 + 1 < var8_8.length && var8_8[var9_9 + 1] == '\'') {
                                if (var1_1.charAt(var4_4) == '\'') {
                                    ++var4_4;
                                    ++var9_9;
                                    break;
                                }
                                var12_12 = 1;
                                break;
                            }
                            var11_11 = 1;
                            break;
                        }
                        default: {
                            if (var1_1.charAt(var4_4) != var8_8[var9_9]) {
                                var12_12 = 1;
                            }
                            ++var4_4;
                        }
                    }
                    ++var9_9;
                }
                if (var12_12 == 0 && var4_4 < var5_5) ** GOTO lbl51
                var2_2.setIndex(var3_3);
                var2_2.setErrorIndex(var4_4);
                return null;
lbl-1000:
                // 1 sources

                {
                    if (var4_4 >= var5_5 || var1_1.charAt(var4_4) != var8_8[var9_9]) {
                        var2_2.setIndex(var3_3);
                        var2_2.setErrorIndex(var4_4);
                        return null;
                    }
                    ++var4_4;
                    ++var9_9;
lbl51:
                    // 2 sources

                    ** while (var9_9 < var8_8.length && var8_8[var9_9] != '\'')
                }
lbl52:
                // 1 sources

                ++var9_9;
                continue;
            }
            if (var10_10 >= 'a' && var10_10 <= 'z' || var10_10 >= 'A' && var10_10 <= 'Z') {
                var11_11 = 1;
                var12_12 = -1;
                while (var9_9 < var8_8.length && var8_8[var9_9] == var10_10) {
                    ++var11_11;
                    ++var9_9;
                }
                while (true) {
                    if (var4_4 >= var5_5) {
                        var2_2.setIndex(var3_3);
                        var2_2.setErrorIndex(var4_4);
                        return null;
                    }
                    var13_13 = var1_1.charAt(var4_4);
                    if (var13_13 != ' ' && var13_13 != '\t') break;
                    ++var4_4;
                }
                var2_2.setIndex(var4_4);
                if (SimpleDateFormat.NUMERIC_PATTERN.indexOf(var10_10) != -1 || var10_10 == 'M' && var11_11 <= 2) {
                    if (var9_9 < var8_8.length && "GyMdkHmsSEDFwWahKz".indexOf(var8_8[var9_9]) != -1) {
                        if (var4_4 + var11_11 > var5_5) {
                            var2_2.setIndex(var3_3);
                            var2_2.setErrorIndex(var4_4);
                            return null;
                        }
                        var13_14 = this.numberFormat.parse(var1_1.substring(0, var4_4 + var11_11), var2_2);
                    } else {
                        var13_14 = this.numberFormat.parse(var1_1, var2_2);
                    }
                    if (var13_14 == null) {
                        var2_2.setIndex(var3_3);
                        var2_2.setErrorIndex(var4_4);
                        return null;
                    }
                    var12_12 = var13_14.intValue();
                    switch (var10_10) {
                        case 'y': {
                            if (var11_11 >= 3 || var12_12 < 0 || var2_2.getIndex() - var4_4 > 2) break;
                            var14_15 = Calendar.getInstance().get(1);
                            var15_16 = var14_15 - var14_15 % 100;
                            var16_17 = var15_16 + var12_12;
                            if (var16_17 > var14_15 + 20) {
                                var16_17 -= 100;
                            } else if (var16_17 < var14_15 - 80) {
                                var16_17 += 100;
                            }
                            var12_12 = var16_17;
                            break;
                        }
                        case 'M': {
                            --var12_12;
                            break;
                        }
                        case 'k': {
                            if (var12_12 != 24) break;
                            var12_12 = 0;
                            break;
                        }
                        case 'h': {
                            if (var12_12 != 12) break;
                            var12_12 = 0;
                        }
                    }
                    this.calendar.set(SimpleDateFormat.NUMERIC_FIELD[SimpleDateFormat.NUMERIC_PATTERN.indexOf(var10_10) + 1], var12_12);
                    var4_4 = var2_2.getIndex();
                    continue;
                }
                switch (var10_10) {
                    case 'G': {
                        var4_4 = this.parseField(var1_1, var4_4, 0, this.syms.eras);
                        break;
                    }
                    case 'M': {
                        var4_4 = this.parseField(var1_1, var4_4, 2, this.syms.months);
                        if (var4_4 > 0) break;
                        var4_4 = this.parseField(var1_1, -var4_4, 2, this.syms.shortMonths);
                        break;
                    }
                    case 'E': {
                        var4_4 = this.parseField(var1_1, var4_4, 7, this.syms.weekdays);
                        if (var4_4 > 0) break;
                        var4_4 = this.parseField(var1_1, -var4_4, 7, this.syms.shortWeekdays);
                        break;
                    }
                    case 'a': {
                        var4_4 = this.parseField(var1_1, var4_4, 9, this.syms.amPmStrings);
                        break;
                    }
                    case 'z': {
                        var6_6 = var4_4;
                        var7_7 = var4_4 = this.parseTimeZone(var1_1, var4_4, var5_5);
                        break;
                    }
                    default: {
                        var4_4 = -var4_4;
                    }
                }
                if (var4_4 <= 0) {
                    var2_2.setIndex(var3_3);
                    var2_2.setErrorIndex(-var4_4);
                    return null;
                }
                var2_2.setIndex(var4_4);
                continue;
            }
            if (var4_4 >= var5_5 || var1_1.charAt(var4_4) != var10_10) {
                var2_2.setIndex(var3_3);
                var2_2.setErrorIndex(var4_4);
                return null;
            }
            ++var4_4;
        }
        if (var6_6 != -1) {
            this.reallyParseTimeZone(var1_1, var6_6, var7_7);
        }
        var2_2.setIndex(var4_4);
        return this.calendar.getTime();
    }

    private int parseField(String string, int n, int n2, String[] stringArray) {
        int n3 = -1;
        int n4 = 0;
        int n5 = stringArray.length;
        while (n5-- > 0) {
            int n6 = stringArray[n5].length();
            if (n6 <= n4 || !string.regionMatches(true, n, stringArray[n5], 0, n6)) continue;
            n3 = n5;
            n4 = n6;
        }
        if (n3 >= 0) {
            this.calendar.set(n2, n3);
            return n + n4;
        }
        return -n;
    }

    private void reallyParseTimeZone(String string, int n, int n2) {
        if (string.regionMatches(n, "GMT", 0, 3)) {
            return;
        }
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < this.syms.zoneStrings.length) {
            String[] stringArray = this.syms.zoneStrings[n6];
            int n7 = 1;
            while (n7 <= 4) {
                int n8 = stringArray[n7].length();
                if (n8 > n4 && string.regionMatches(true, n, stringArray[n7], 0, n8)) {
                    n3 = n6;
                    n5 = n7;
                    n4 = n8;
                }
                ++n7;
            }
            ++n6;
        }
        if (n3 != -1) {
            TimeZone timeZone = TimeZone.getTimeZone(this.syms.zoneStrings[n3][n5]);
            long l = timeZone.getOffset(this.calendar.get(0), this.calendar.get(1), this.calendar.get(2), this.calendar.get(5), this.calendar.get(7), this.calendar.get(14));
            this.calendar.set(15, (int)l);
            return;
        }
    }

    private int parseTimeZone(String string, int n, int n2) {
        int n3;
        Object object;
        this.calendar.set(16, 0);
        if (string.regionMatches(n, "GMT", 0, 3)) {
            int n4 = n + 3;
            int n5 = 0;
            if (n4 < n2) {
                switch (string.charAt(n4)) {
                    case '+': {
                        n5 = 1;
                        break;
                    }
                    case '-': {
                        n5 = -1;
                    }
                }
            }
            if (n5 == 0) {
                return n4;
            }
            ParsePosition parsePosition = new ParsePosition(n4 + 1);
            Number number = this.numberFormat.parse(string, parsePosition);
            if (number == null) {
                return -n;
            }
            int n6 = number.intValue();
            if (parsePosition.getIndex() < n2 && string.charAt(parsePosition.getIndex()) == ':') {
                n6 *= 60;
                parsePosition.setIndex(parsePosition.getIndex() + 1);
                number = this.numberFormat.parse(string, parsePosition);
                if (number == null) {
                    return -n;
                }
                n6 += number.intValue();
            } else {
                n6 = n6 < 24 ? (n6 *= 60) : n6 / 100 * 60 + n6 % 100;
            }
            n6 *= 60000;
            if (n5 == -1) {
                n6 = -n6;
            }
            this.calendar.set(15, n6);
            return parsePosition.getIndex();
        }
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        while (n10 < this.syms.zoneStrings.length) {
            object = this.syms.zoneStrings[n10];
            int n11 = 1;
            while (n11 <= 4) {
                n3 = object[n11].length();
                if (n3 > n8 && string.regionMatches(true, n, object[n11], 0, n3)) {
                    n7 = n10;
                    n9 = n11;
                    n8 = n3;
                }
                ++n11;
            }
            ++n10;
        }
        if (n7 != -1) {
            TimeZone timeZone = TimeZone.getTimeZone(this.syms.zoneStrings[n7][n9]);
            return n + n8;
        }
        DecimalFormat decimalFormat = new DecimalFormat("+####;-####");
        decimalFormat.setParseIntegerOnly(true);
        decimalFormat.setGroupingUsed(false);
        object = new ParsePosition(n);
        Number number = decimalFormat.parse(string, (ParsePosition)object);
        if (number == null) {
            return -n;
        }
        n3 = number.intValue();
        int n12 = 1;
        if (n3 < 0) {
            n12 = -1;
            n3 = -n3;
        }
        n3 = n3 < 24 ? (n3 *= 60) : n3 / 100 * 60 + n3 % 100;
        n3 *= 60000;
        if (n12 == -1) {
            n3 = -n3;
        }
        this.calendar.set(15, n3);
        return ((ParsePosition)object).getIndex();
    }

    public void setDateFormatSymbols(DateFormatSymbols dateFormatSymbols) {
        this.syms = dateFormatSymbols;
    }

    public String toLocalizedPattern() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = this.syms.getLocalPatternChars();
        int n = 0;
        while (n < this.pattern.length()) {
            int n2 = DEFAULTPATTERNCHARS.indexOf(this.pattern.charAt(n));
            if (n2 >= 0) {
                stringBuffer.append(string.charAt(n2));
            } else {
                stringBuffer.append(this.pattern.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String toPattern() {
        return this.pattern;
    }
}

