/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCollection
implements Collection {
    protected AbstractCollection() {
    }

    @Override
    public abstract Iterator iterator();

    @Override
    public abstract int size();

    @Override
    public boolean add(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection collection) {
        Iterator iterator = collection.iterator();
        boolean bl = false;
        int n = collection.size();
        while (--n >= 0) {
            bl |= this.add(iterator.next());
        }
        return bl;
    }

    @Override
    public void clear() {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            iterator.next();
            iterator.remove();
        }
    }

    @Override
    public boolean contains(Object object) {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, iterator.next())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean remove(Object object) {
        Iterator iterator = this.iterator();
        int n = this.size();
        while (--n >= 0) {
            if (!AbstractCollection.equals(object, iterator.next())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection collection) {
        return this.removeAllInternal(collection);
    }

    boolean removeAllInternal(Collection collection) {
        Iterator iterator = this.iterator();
        boolean bl = false;
        int n = this.size();
        while (--n >= 0) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection collection) {
        return this.retainAllInternal(collection);
    }

    boolean retainAllInternal(Collection collection) {
        Iterator iterator = this.iterator();
        boolean bl = false;
        int n = this.size();
        while (--n >= 0) {
            if (collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public Object[] toArray() {
        Iterator iterator = this.iterator();
        int n = this.size();
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        int n = this.size();
        if (objectArray.length < n) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        } else if (objectArray.length > n) {
            objectArray[n] = null;
        }
        Iterator iterator = this.iterator();
        int n2 = 0;
        while (n2 < n) {
            objectArray[n2] = iterator.next();
            ++n2;
        }
        return objectArray;
    }

    public String toString() {
        Iterator iterator = this.iterator();
        StringBuffer stringBuffer = new StringBuffer("[");
        int n = this.size();
        while (n > 0) {
            stringBuffer.append(iterator.next());
            if (n > 1) {
                stringBuffer.append(", ");
            }
            --n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static final boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    static final int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        return object.hashCode();
    }
}

