/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractMapEntry;
import java.util.AbstractMapEntrySet;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMap
extends AbstractMap
implements Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    private static final float DEFAULT_LOADFACTOR = 0.75f;
    static final long serialVersionUID = 362498820763181265L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("threshold", Integer.TYPE), new ObjectStreamField("loadFactor", Float.TYPE)};
    float loadFactor;
    Entry[] table;
    private int modCount;
    private int size;

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap(int n, float f) {
        if (n < 0 || f <= 0.0f) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            n = 1;
        }
        this.table = new Entry[n];
        this.loadFactor = f;
    }

    public HashMap(Map map) {
        int n = map.size() * 2;
        if (n < 11) {
            n = 11;
        }
        this.table = new Entry[n];
        this.loadFactor = 0.75f;
        this.putAll(map);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsValue(Object object) {
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                if (!(object != null ? !object.equals(entry.value) : entry.value != null)) {
                    return true;
                }
                entry = entry.next;
            }
            ++n;
        }
        return false;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.find(object) != null;
    }

    @Override
    public Object get(Object object) {
        Entry entry = this.find(object);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    int getTableLength() {
        return this.table.length;
    }

    @Override
    public Object put(Object object, Object object2) {
        int n = HashMap.bucket(object, this.table.length);
        Entry entry = this.find(object, n);
        if (entry != null) {
            Object object3 = entry.value;
            entry.value = object2;
            return object3;
        }
        if ((float)this.size / (float)this.table.length >= this.loadFactor) {
            this.rehash();
            n = HashMap.bucket(object, this.table.length);
        }
        entry = new Entry(object, object2);
        entry.next = this.table[n];
        this.table[n] = entry;
        ++this.modCount;
        ++this.size;
        return null;
    }

    @Override
    public Object remove(Object object) {
        int n = HashMap.bucket(object, this.table.length);
        Entry entry = this.table[n];
        if (entry == null) {
            return null;
        }
        if (!(object != null ? !object.equals(entry.key) : entry.key != null)) {
            Object object2 = entry.value;
            this.table[n] = entry.next;
            ++this.modCount;
            this.size += -1;
            return object2;
        }
        Entry entry2 = entry;
        while (entry2.next != null) {
            if (!(object != null ? !object.equals(((Entry)entry2).next.key) : ((Entry)entry2).next.key != null)) {
                Object object3 = ((Entry)entry2).next.value;
                entry2.next = entry2.next.next;
                ++this.modCount;
                this.size += -1;
                return object3;
            }
            entry2 = entry2.next;
        }
        return null;
    }

    @Override
    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.table = new Entry[11];
        ++this.modCount;
        this.size = 0;
    }

    public Object clone() {
        HashMap hashMap;
        try {
            hashMap = (HashMap)super.clone();
            hashMap.keyset = null;
            hashMap.valcol = null;
            hashMap.table = new Entry[this.table.length];
            int n = 0;
            while (n < this.table.length) {
                Entry entry = this.table[n];
                if (entry != null) {
                    Entry entry2;
                    hashMap.table[n] = entry2 = new Entry(entry.key, entry.value);
                    Entry entry3 = entry.next;
                    while (entry3 != null) {
                        entry2.next = new Entry(entry3.key, entry3.value);
                        entry2 = entry2.next;
                        entry3 = entry3.next;
                    }
                }
                ++n;
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            hashMap = null;
        }
        return hashMap;
    }

    @Override
    public Set entrySet() {
        return new 1(this);
    }

    void rehash() {
        Entry[] entryArray = new Entry[this.table.length * 2];
        int n = 0;
        while (n < this.table.length) {
            Entry entry = this.table[n];
            while (entry != null) {
                Entry entry2 = entry.next;
                int n2 = HashMap.bucket(entry.key, entryArray.length);
                entry.next = entryArray[n2];
                entryArray[n2] = entry;
                entry = entry2;
            }
            ++n;
        }
        this.table = entryArray;
    }

    private Entry find(Object object) {
        return this.find(object, HashMap.bucket(object, this.table.length));
    }

    private Entry find(Object object, int n) {
        Entry entry = this.table[n];
        while (entry != null) {
            if (!(object != null ? !object.equals(entry.key) : entry.key != null)) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    private static final int bucket(Object object, int n) {
        int n2 = object == null ? 0 : object.hashCode();
        return (n2 &= Integer.MAX_VALUE) % n;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.loadFactor = getField.get("loadFactor", 0.75f);
        int n = getField.get("threshold", 0);
        int n2 = objectInputStream.readInt();
        this.table = new Entry[n2];
        int n3 = objectInputStream.readInt();
        while (n3-- > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put("loadFactor", this.loadFactor);
        putField.put("threshold", (int)((float)this.size() * this.loadFactor));
        objectOutputStream.writeFields();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size());
        Iterator iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            objectOutputStream.writeObject(entry.getKey());
            objectOutputStream.writeObject(entry.getValue());
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    extends AbstractMapEntry {
        private Entry next = null;

        Entry(Object object, Object object2) {
            super(object, object2);
        }

        @Override
        public void changeValue(Object object) {
            HashMap.this.put(this.key, object);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIterator
    implements Iterator {
        private int bucket;
        private int modCount;
        private Entry next;
        private Entry prev;

        EntryIterator() {
            this.modCount = HashMap.this.modCount;
            this.bucket = -1;
            this.nextBucket();
        }

        @Override
        public boolean hasNext() {
            if (this.modCount != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null;
        }

        @Override
        public Object next() {
            if (this.modCount != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.next;
            this.next = this.next.next;
            if (this.next == null) {
                this.nextBucket();
            }
            return this.prev;
        }

        @Override
        public void remove() {
            if (this.modCount != HashMap.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.prev == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.prev.key);
            ++this.modCount;
            this.prev = null;
        }

        private void nextBucket() {
            while (++this.bucket < HashMap.this.table.length && HashMap.this.table[this.bucket] == null) {
            }
            if (this.bucket < HashMap.this.table.length) {
                this.next = HashMap.this.table[this.bucket];
            }
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 1
    extends AbstractMapEntrySet {
        @Override
        public Iterator iterator() {
            return new EntryIterator();
        }

        @Override
        protected Map.Entry find(Map.Entry entry) {
            Entry entry2 = HashMap.this.find(entry.getKey());
            if (entry.equals(entry2)) {
                return entry2;
            }
            return null;
        }

        public 1(Map map) {
            super(map);
        }
    }
}

