/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedListIterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList
extends AbstractSequentialList
implements Cloneable,
Serializable {
    Elem head;
    Elem tail;
    int length;

    public LinkedList() {
        this.Block$();
    }

    public LinkedList(Collection collection) {
        this.Block$();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addLast(iterator.next());
        }
    }

    public Object getFirst() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.head.o;
    }

    public Object getLast() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        return this.tail.o;
    }

    public Object removeFirst() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        Object object = this.head.o;
        this.head = this.head.next;
        if (this.head == null) {
            this.tail = null;
        } else {
            this.head.prev = null;
        }
        this.length += -1;
        return object;
    }

    public Object removeLast() {
        if (this.length == 0) {
            throw new NoSuchElementException();
        }
        ++this.modCount;
        Object object = this.tail.o;
        this.tail = this.tail.prev;
        if (this.tail == null) {
            this.head = null;
        } else {
            this.tail.next = null;
        }
        this.length += -1;
        return object;
    }

    public void addFirst(Object object) {
        Elem elem = new Elem(object);
        ++this.modCount;
        if (this.length == 0) {
            this.head = this.tail = elem;
        } else {
            elem.next = this.head;
            this.head.prev = elem;
            this.head = elem;
        }
        ++this.length;
    }

    public void addLast(Object object) {
        Elem elem = new Elem(object);
        ++this.modCount;
        if (this.length == 0) {
            this.head = this.tail = elem;
        } else {
            elem.prev = this.tail;
            this.tail.next = elem;
            this.tail = elem;
        }
        ++this.length;
    }

    @Override
    public boolean contains(Object object) {
        return this.findObject(object) != null;
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public boolean add(Object object) {
        this.addLast(object);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        Elem elem = this.findObject(object);
        if (elem != null) {
            this.remove(elem);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.length, collection);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean addAll(int var1_1, Collection var2_2) {
        block8: {
            block7: {
                if (var1_1 < 0 || var1_1 > this.length) {
                    throw new IndexOutOfBoundsException();
                }
                var3_3 = new LinkedList(var2_2);
                if (var3_3.length == 0) {
                    return false;
                }
                if (var1_1 != 0) break block7;
                var4_4 = null;
                var5_5 = this.tail;
                break block8;
            }
            var4_4 = this.head;
            if (true) ** GOTO lbl15
            do {
                var4_4 = var4_4.next;
lbl15:
                // 2 sources

                v0 = --var1_1;
                --var1_1;
            } while (v0 > 0);
            var5_5 = var4_4 == null ? null : var4_4.next;
        }
        ++this.modCount;
        var3_3.head.prev = var4_4;
        var3_3.tail.next = var5_5;
        if (var4_4 == null) {
            this.head = var3_3.head;
        } else {
            var4_4.next = var3_3.head;
        }
        if (var5_5 == null) {
            this.tail = var3_3.tail;
        } else {
            var5_5.prev = var3_3.tail;
        }
        this.length += var3_3.length;
        return true;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.head = null;
        this.tail = null;
        this.length = 0;
    }

    @Override
    public Object get(int n) {
        return this.findIndex((int)n).o;
    }

    @Override
    public Object set(int n, Object object) {
        Elem elem = this.findIndex(n);
        Object object2 = elem.o;
        elem.o = object;
        return object2;
    }

    @Override
    public void add(int n, Object object) {
        if (n == this.length) {
            this.addLast(object);
            return;
        }
        Elem elem = this.findIndex(n);
        Elem elem2 = new Elem(object);
        ++this.modCount;
        elem2.prev = elem.prev;
        elem2.next = elem;
        elem.prev = elem2;
        if (elem2.prev == null) {
            this.head = elem2;
        } else {
            elem2.prev.next = elem2;
        }
        ++this.length;
    }

    @Override
    public Object remove(int n) {
        Elem elem = this.findIndex(n);
        Object object = elem.o;
        this.remove(elem);
        return object;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        Elem elem = this.head;
        while (elem != null) {
            if (!(object != null ? !object.equals(elem.o) : elem.o != null)) {
                return n;
            }
            elem = elem.next;
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.length - 1;
        Elem elem = this.tail;
        while (elem != null) {
            if (!(object != null ? !object.equals(elem.o) : elem.o != null)) {
                return n;
            }
            elem = elem.prev;
            --n;
        }
        return -1;
    }

    @Override
    public ListIterator listIterator(int n) {
        return new LinkedListIterator(this, n);
    }

    public Object clone() {
        LinkedList linkedList;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
        linkedList.clear();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            linkedList.addLast(iterator.next());
        }
        return linkedList;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        int n = 0;
        Elem elem = this.head;
        while (elem != null) {
            objectArray[n++] = elem.o;
            elem = elem.next;
        }
        return objectArray;
    }

    @Override
    public Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.length) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.length);
        }
        int n = 0;
        Elem elem = this.head;
        while (elem != null) {
            objectArray[n++] = elem.o;
            elem = elem.next;
        }
        if (objectArray.length > this.length) {
            objectArray[this.length] = null;
        }
        return objectArray;
    }

    private Elem findObject(Object object) {
        Elem elem = this.head;
        while (elem != null) {
            if (!(object != null ? !object.equals(elem.o) : elem.o != null)) {
                return elem;
            }
            elem = elem.next;
        }
        return null;
    }

    private Elem findIndex(int n) {
        if (n < 0 || n >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        Elem elem = this.head;
        while (n-- > 0) {
            elem = elem.next;
        }
        return elem;
    }

    void add(Elem elem, Object object) {
        if (elem == null) {
            this.addLast(object);
            return;
        }
        Elem elem2 = new Elem(object);
        ++this.modCount;
        elem2.prev = elem.prev;
        elem2.next = elem;
        elem.prev = elem2;
        if (elem2.prev == null) {
            this.head = elem2;
        } else {
            elem2.prev.next = elem2;
        }
        ++this.length;
    }

    Elem remove(Elem elem) {
        if (elem.prev == null) {
            this.removeFirst();
            return this.head;
        }
        if (elem.next == null) {
            this.removeLast();
            return null;
        }
        ++this.modCount;
        elem.prev.next = elem.next;
        elem.next.prev = elem.prev;
        this.length += -1;
        return elem.next;
    }

    private /* synthetic */ void Block$() {
        this.head = null;
        this.tail = null;
        this.length = 0;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Elem {
        public Object o;
        public Elem prev;
        public Elem next;

        Elem(Object object) {
            this.o = object;
            this.prev = null;
            this.next = null;
        }
    }
}

