/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractListIterator;
import java.util.ConcurrentModificationException;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class LinkedListIterator
extends AbstractListIterator {
    LinkedList.Elem elem;

    LinkedListIterator(LinkedList linkedList, int n) {
        super(linkedList, n);
        this.elem = linkedList.head;
        while (n > 0) {
            this.elem = this.elem.next;
            --n;
        }
    }

    @Override
    public Object next() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.index >= ((LinkedList)this.list).length) {
            throw new NoSuchElementException();
        }
        Object object = this.elem.o;
        this.lastIndex = this.index++;
        this.elem = this.elem.next;
        return object;
    }

    @Override
    public Object previous() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.index <= 0) {
            throw new NoSuchElementException();
        }
        this.elem = this.elem == null ? ((LinkedList)this.list).tail : this.elem.prev;
        this.lastIndex = this.index += -1;
        return this.elem.o;
    }

    @Override
    public void remove() {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastIndex == -1) {
            throw new IllegalStateException();
        }
        if (this.lastIndex == this.index) {
            this.elem = ((LinkedList)this.list).remove(this.elem);
        } else {
            ((LinkedList)this.list).remove(this.elem == null ? ((LinkedList)this.list).tail : this.elem.prev);
            this.index += -1;
        }
        ++this.modCount;
        this.lastIndex = -1;
    }

    @Override
    public void set(Object object) {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        if (this.lastIndex == -1) {
            throw new IllegalStateException();
        }
        if (this.lastIndex == this.index) {
            this.elem.o = object;
            return;
        }
        (this.elem == null ? ((LinkedList)this.list).tail : this.elem.prev).o = object;
    }

    @Override
    public void add(Object object) {
        if (this.list.modCount != this.modCount) {
            throw new ConcurrentModificationException();
        }
        ((LinkedList)this.list).add(this.elem, object);
        ++this.modCount;
        ++this.index;
        if (this.elem != null) {
            this.elem = this.elem.next;
        }
    }
}

