/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import kaffe.lang.ThreadStack;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceBundle {
    protected ResourceBundle parent = null;
    static Hashtable cache = new Hashtable();
    private Locale locale;

    public static final ResourceBundle getBundle(String string) throws MissingResourceException {
        return ResourceBundle.getBundle(string, Locale.getDefault(), ThreadStack.getCallersClassLoader(true));
    }

    public static final ResourceBundle getBundle(String string, Locale locale2) throws MissingResourceException {
        return ResourceBundle.getBundle(string, locale2, ThreadStack.getCallersClassLoader(true));
    }

    public static ResourceBundle getBundle(String string, Locale locale2, ClassLoader classLoader) throws MissingResourceException {
        ResourceBundle resourceBundle;
        ResourceBundle resourceBundle2 = ResourceBundle.getSpecificBundle(string, classLoader);
        if (resourceBundle2 != null) {
            resourceBundle2.parent = null;
            resourceBundle2.locale = new Locale("");
        }
        if ((resourceBundle = ResourceBundle.getBundleWithLocale(string, resourceBundle2, locale2, classLoader)) == resourceBundle2 && locale2 != Locale.getDefault()) {
            resourceBundle = ResourceBundle.getBundleWithLocale(string, resourceBundle2, Locale.getDefault(), classLoader);
        }
        if (resourceBundle == null) {
            throw new MissingResourceException(new StringBuffer().append("Can't find bundle for base name ").append(string).append(",locale ").append(locale2).toString(), "ResourceBundle", string);
        }
        return resourceBundle;
    }

    private static final ResourceBundle getBundleWithLocale(String string, ResourceBundle resourceBundle, Locale locale2, ClassLoader classLoader) {
        ResourceBundle resourceBundle2 = null;
        String string2 = locale2.getLanguage();
        String string3 = locale2.getCountry();
        String string4 = locale2.getVariant();
        StringBuffer stringBuffer = new StringBuffer(60);
        stringBuffer.append(string);
        stringBuffer.append('_');
        if (string2.length() > 0) {
            stringBuffer.append(string2);
            resourceBundle2 = ResourceBundle.getSpecificBundle(stringBuffer.toString(), classLoader);
            if (resourceBundle2 != null) {
                resourceBundle2.parent = resourceBundle;
                resourceBundle2.locale = new Locale(string2);
                resourceBundle = resourceBundle2;
            }
        }
        stringBuffer.append('_');
        if (string3.length() > 0) {
            stringBuffer.append(string3);
            resourceBundle2 = ResourceBundle.getSpecificBundle(stringBuffer.toString(), classLoader);
            if (resourceBundle2 != null) {
                resourceBundle2.parent = resourceBundle;
                resourceBundle2.locale = new Locale(string2, string3);
                resourceBundle = resourceBundle2;
            }
        }
        if (string4.length() > 0) {
            stringBuffer.append('_');
            stringBuffer.append(string4);
            resourceBundle2 = ResourceBundle.getSpecificBundle(stringBuffer.toString(), classLoader);
            if (resourceBundle2 != null) {
                resourceBundle2.parent = resourceBundle;
                resourceBundle2.locale = new Locale(string2, string3, string4);
                resourceBundle = resourceBundle2;
            }
        }
        return resourceBundle;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public abstract Enumeration getKeys();

    public final Object getObject(String string) throws MissingResourceException {
        try {
            Object object = this.handleGetObject(string);
            if (object != null) {
                return object;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (this.parent == null) {
            throw new MissingResourceException("resource not found", this.getClass().toString(), string);
        }
        return this.parent.getObject(string);
    }

    private static final ResourceBundle getSpecificBundle(String string, ClassLoader classLoader) {
        Object object;
        ResourceBundle resourceBundle = (ResourceBundle)cache.get(new StringBuffer().append(classLoader).append(string).toString());
        if (resourceBundle != null) {
            return resourceBundle;
        }
        try {
            object = Class.forName(string, true, classLoader);
            if (Class.forName("java.util.ResourceBundle").isAssignableFrom((Class)object)) {
                resourceBundle = (ResourceBundle)((Class)object).newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resourceBundle == null && (object = classLoader.getResourceAsStream(new StringBuffer().append(string.replace('.', '/')).append(".properties").toString())) != null) {
            try {
                resourceBundle = new PropertyResourceBundle((InputStream)object);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (resourceBundle != null) {
            cache.put(string, resourceBundle);
        }
        return resourceBundle;
    }

    public final String getString(String string) throws MissingResourceException {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) throws MissingResourceException {
        return (String[])this.getObject(string);
    }

    protected abstract Object handleGetObject(String var1) throws MissingResourceException;

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }
}

