/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
class SubList
extends AbstractList {
    final AbstractList backingList;
    final int offset;
    int size;

    SubList(AbstractList abstractList, int n, int n2) {
        this.backingList = abstractList;
        this.modCount = abstractList.modCount;
        this.offset = n;
        this.size = n2 - n;
    }

    void checkMod() {
        if (this.modCount != this.backingList.modCount) {
            throw new ConcurrentModificationException();
        }
    }

    private void checkBoundsInclusive(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(new StringBuffer().append("Index: ").append(n).append(", Size:").append(this.size).toString());
        }
    }

    private void checkBoundsExclusive(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(new StringBuffer().append("Index: ").append(n).append(", Size:").append(this.size).toString());
        }
    }

    @Override
    public int size() {
        this.checkMod();
        return this.size;
    }

    @Override
    public Object set(int n, Object object) {
        this.checkMod();
        this.checkBoundsExclusive(n);
        return this.backingList.set(n + this.offset, object);
    }

    @Override
    public Object get(int n) {
        this.checkMod();
        this.checkBoundsExclusive(n);
        return this.backingList.get(n + this.offset);
    }

    @Override
    public void add(int n, Object object) {
        this.checkMod();
        this.checkBoundsInclusive(n);
        this.backingList.add(n + this.offset, object);
        ++this.size;
        this.modCount = this.backingList.modCount;
    }

    @Override
    public Object remove(int n) {
        this.checkMod();
        this.checkBoundsExclusive(n);
        Object object = this.backingList.remove(n + this.offset);
        this.size += -1;
        this.modCount = this.backingList.modCount;
        return object;
    }

    @Override
    protected void removeRange(int n, int n2) {
        this.checkMod();
        this.backingList.removeRange(this.offset + n, this.offset + n2);
        this.size -= n2 - n;
        this.modCount = this.backingList.modCount;
    }

    @Override
    public boolean addAll(int n, Collection collection) {
        this.checkMod();
        this.checkBoundsInclusive(n);
        int n2 = collection.size();
        boolean bl = this.backingList.addAll(this.offset + n, collection);
        this.size += n2;
        this.modCount = this.backingList.modCount;
        return bl;
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public Iterator iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator listIterator(int n) {
        this.checkMod();
        this.checkBoundsInclusive(n);
        return new 1(this, n);
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class 1
    implements ListIterator {
        private final ListIterator i;
        private int position;
        private final /* synthetic */ SubList this$0;
        private final /* synthetic */ int var$index;

        @Override
        public boolean hasNext() {
            this.this$0.checkMod();
            return this.position < this.this$0.size;
        }

        @Override
        public boolean hasPrevious() {
            this.this$0.checkMod();
            return this.position > 0;
        }

        @Override
        public Object next() {
            if (this.position == this.this$0.size) {
                throw new NoSuchElementException();
            }
            ++this.position;
            return this.i.next();
        }

        @Override
        public Object previous() {
            if (this.position == 0) {
                throw new NoSuchElementException();
            }
            this.position += -1;
            return this.i.previous();
        }

        @Override
        public int nextIndex() {
            return this.i.nextIndex() - this.this$0.offset;
        }

        @Override
        public int previousIndex() {
            return this.i.previousIndex() - this.this$0.offset;
        }

        @Override
        public void remove() {
            this.i.remove();
            this.this$0.size += -1;
            this.position = this.nextIndex();
            this.this$0.modCount = this.this$0.backingList.modCount;
        }

        @Override
        public void set(Object object) {
            this.i.set(object);
        }

        @Override
        public void add(Object object) {
            this.i.add(object);
            ++this.this$0.size;
            ++this.position;
            this.this$0.modCount = this.this$0.backingList.modCount;
        }

        public 1() {
            this.this$0 = var1_1;
            this.var$index = n;
            this.Block$();
        }

        private /* synthetic */ void Block$() {
            this.i = this.this$0.backingList.listIterator(this.var$index + this.this$0.offset);
            this.position = this.var$index;
        }
    }
}

