/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Vector
extends AbstractList
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -2767605614048989439L;
    protected int capacityIncrement;
    protected int elementCount;
    protected Object[] elementData;

    public Vector() {
        this(10, 0);
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector(int n, int n2) {
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public Vector(Collection collection) {
        this(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addElement(iterator.next());
        }
    }

    public synchronized void addElement(Object object) {
        this.insertElementAt(object, this.size());
    }

    @Override
    public synchronized boolean add(Object object) {
        this.insertElementAt(object, this.size());
        return true;
    }

    @Override
    public void add(int n, Object object) {
        this.insertElementAt(object, n);
    }

    @Override
    public boolean addAll(Collection collection) {
        return this.addAll(this.size(), collection);
    }

    @Override
    public synchronized boolean addAll(int n, Collection collection) {
        this.ensureCapacity(this.size() + collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(n++, iterator.next());
        }
        return collection.size() > 0;
    }

    public int capacity() {
        return this.elementData.length;
    }

    @Override
    public void clear() {
        this.removeAllElements();
    }

    public synchronized Object clone() {
        try {
            Vector vector = (Vector)super.clone();
            vector.elementData = (Object[])this.elementData.clone();
            return vector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public boolean containsAll(Collection collection) {
        return super.containsAll(collection);
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized Object elementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(new StringBuffer().append("Array index out of range: ").append(Integer.toString(n)).append(" >= ").append(this.elementCount).toString());
        }
        return this.elementData[n];
    }

    public synchronized Enumeration elements() {
        return new 1();
    }

    public synchronized void ensureCapacity(int n) {
        if (this.elementData.length < n) {
            int n2 = this.elementData.length;
            n2 = this.capacityIncrement > 0 ? (n2 += this.capacityIncrement) : (n2 *= 2);
            if (n2 < n) {
                n2 = n;
            }
            ++this.modCount;
            Object[] objectArray = this.elementData;
            this.elementData = new Object[n2];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    @Override
    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.size() != list.size()) {
                return false;
            }
            Iterator iterator = list.iterator();
            int n = 0;
            while (iterator.hasNext() && n < this.elementCount) {
                Object object2 = this.elementData[n];
                Object object3 = iterator.next();
                if (!(object2 == object3 || object2 != null && object2.equals(object3))) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public synchronized Object firstElement() {
        if (this.elementCount <= 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    @Override
    public Object get(int n) {
        return this.elementAt(n);
    }

    @Override
    public int hashCode() {
        int n = 1;
        int n2 = 0;
        while (n2 < this.size()) {
            Object object = this.elementData[n2];
            n = 31 * n + (object == null ? 0 : object.hashCode());
            ++n2;
        }
        return n;
    }

    private void increaseCapacity() {
        int n = this.elementData.length;
        n = this.capacityIncrement > 0 ? (n += this.capacityIncrement) : (n == 0 ? 10 : (n *= 2));
        this.ensureCapacity(n);
    }

    @Override
    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        int n2 = n;
        while (n2 < this.elementCount) {
            Object object2 = this.elementData[n2];
            if (object == object2 || object != null && object.equals(object2)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public synchronized void insertElementAt(Object object, int n) {
        int n2 = this.modCount;
        if (this.elementCount == this.elementData.length) {
            this.increaseCapacity();
        }
        this.modCount = n2 + 1;
        if (n > this.elementCount || n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        }
        this.elementData[n] = object;
        ++this.elementCount;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.size() - 1);
    }

    public synchronized int lastIndexOf(Object object, int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = n;
        while (n2 >= 0) {
            Object object2 = this.elementData[n2];
            if (object == object2 || object != null && object.equals(object2)) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    @Override
    public synchronized Object remove(int n) {
        Object object = this.elementAt(n);
        this.removeElementAt(n);
        return object;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.remove(n);
        return true;
    }

    @Override
    public synchronized boolean removeAll(Collection collection) {
        if (collection.size() == 0) {
            return false;
        }
        int n = this.elementCount;
        int n2 = 0;
        while (n2 < this.elementCount) {
            Object object = this.elementData[n2];
            if (collection.contains(object)) {
                this.remove(n2);
                --n2;
            }
            ++n2;
        }
        return n != this.elementCount;
    }

    @Override
    public synchronized boolean retainAll(Collection collection) {
        if (collection.size() == 0) {
            this.removeAllElements();
            return true;
        }
        int n = this.elementCount;
        int n2 = 0;
        while (n2 < this.elementCount) {
            Object object = this.elementData[n2];
            if (!collection.contains(object)) {
                this.remove(n2);
                --n2;
            }
            ++n2;
        }
        return n != this.elementCount;
    }

    public synchronized void removeAllElements() {
        Arrays.fill(this.elementData, 0, this.elementCount, null);
        this.elementCount = 0;
        ++this.modCount;
    }

    public synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object);
        if (n == -1) {
            return false;
        }
        this.removeElementAt(n);
        return true;
    }

    public synchronized void removeElementAt(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        ++this.modCount;
        System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n - 1);
        this.elementCount += -1;
        this.elementData[this.elementCount] = null;
    }

    @Override
    public Object set(int n, Object object) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException();
        }
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    public synchronized void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public synchronized void setSize(int n) {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n2 = this.modCount;
        this.ensureCapacity(n);
        this.modCount = n2 + 1;
        this.elementCount = n;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public List subList(int n, int n2) {
        return super.subList(n, n2);
    }

    @Override
    public synchronized Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        this.copyInto(objectArray);
        return objectArray;
    }

    @Override
    public synchronized Object[] toArray(Object[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        this.copyInto(objectArray);
        if (objectArray.length > this.elementCount) {
            objectArray[this.elementCount] = null;
        }
        return objectArray;
    }

    @Override
    public synchronized String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.elementCount) {
            Object object;
            if (n > 0) {
                stringBuffer.append(", ");
            }
            String string = (object = this.elementData[n]) == null ? "null" : object.toString();
            stringBuffer.append(string);
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public synchronized void trimToSize() {
        if (this.elementCount != this.elementData.length) {
            Object[] objectArray = this.elementData;
            this.elementData = new Object[this.elementCount];
            System.arraycopy(objectArray, 0, this.elementData, 0, this.elementCount);
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        int n3 = n2 - n;
        if (n3 > 0) {
            System.arraycopy(this.elementData, n2, this.elementData, n, this.elementCount - n2);
        } else if (n3 < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.elementCount -= n3;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class 1
    implements Enumeration {
        int index;

        @Override
        public boolean hasMoreElements() {
            return this.index < Vector.this.elementCount;
        }

        @Override
        public Object nextElement() {
            if (this.index >= Vector.this.elementCount) {
                throw new NoSuchElementException();
            }
            return Vector.this.elementData[this.index++];
        }

        public 1() {
            this.Block$();
        }

        private /* synthetic */ void Block$() {
            this.index = 0;
        }
    }
}

