/*
 * Decompiled with CFR 0.152.
 */
package java.util.jar;

import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarException;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarInputStream
extends ZipInputStream {
    private final Manifest manifest;
    private boolean gotNext;
    private ZipEntry next = super.getNextEntry();

    public JarInputStream(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public JarInputStream(InputStream inputStream, boolean bl) throws IOException {
        super(inputStream);
        if (this.next.getName().equals("META-INF/MANIFEST.MF")) {
            this.manifest = new Manifest(this);
            this.closeEntry();
            if (bl) {
                this.verifyIfSigned();
                return;
            }
        } else {
            this.manifest = null;
            this.gotNext = true;
        }
    }

    private void verifyIfSigned() throws JarException {
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    public ZipEntry getNextEntry() throws IOException {
        return this.getNextJarEntry();
    }

    public JarEntry getNextJarEntry() throws IOException {
        if (this.gotNext) {
            this.gotNext = false;
        } else {
            this.next = super.getNextEntry();
        }
        if (this.next == null) {
            return null;
        }
        return new JarEntry(this.next, this.manifest == null ? null : this.manifest.getAttributes(this.next.getName()));
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    @Override
    protected ZipEntry createZipEntry(String string) {
        return super.createZipEntry(string);
    }
}

