/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StreamHandler
extends Handler {
    private OutputStream out;
    private Writer writer;
    private int streamState;
    private static final int STATE_FRESH = 0;
    private static final int STATE_PUBLISHED = 1;
    private static final int STATE_CLOSED = 2;

    public StreamHandler() {
        this(null, null);
    }

    public StreamHandler(OutputStream outputStream, Formatter formatter) {
        this(outputStream, "java.util.logging.StreamHandler", Level.INFO, formatter, Class.forName("java.util.logging.SimpleFormatter"));
    }

    StreamHandler(OutputStream outputStream, String string, Level level, Formatter formatter, Class clazz) {
        this.Block$();
        this.level = LogManager.getLevelProperty(new StringBuffer().append(string).append(".level").toString(), level);
        this.filter = (Filter)LogManager.getInstanceProperty(new StringBuffer().append(string).append(".filter").toString(), Class.forName("java.util.logging.Filter"), null);
        this.formatter = formatter != null ? formatter : (Formatter)LogManager.getInstanceProperty(new StringBuffer().append(string).append(".formatter").toString(), Class.forName("java.util.logging.Formatter"), clazz);
        try {
            String string2 = LogManager.getLogManager().getProperty(new StringBuffer().append(string).append(".encoding").toString());
            if (string2 != null && string2.length() > 0) {
                new String(new byte[0], string2);
            }
            this.encoding = string2;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (outputStream != null) {
            try {
                this.changeWriter(outputStream, this.getEncoding());
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException.getMessage());
            }
        }
    }

    private void checkOpen() {
        if (this.streamState == 2) {
            throw new IllegalStateException(new StringBuffer().append(this.toString()).append(" has been closed").toString());
        }
    }

    private void checkFresh() {
        this.checkOpen();
        if (this.streamState != 0) {
            throw new IllegalStateException(new StringBuffer().append("some log records have been published to ").append(this).toString());
        }
    }

    private void changeWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        OutputStreamWriter outputStreamWriter = string == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, string);
        if (this.streamState != 0 || this.writer != null) {
            this.close();
        }
        this.writer = outputStreamWriter;
        this.out = outputStream;
        this.encoding = string;
        this.streamState = 0;
    }

    @Override
    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        super.setEncoding(string);
        this.checkFresh();
        if (this.out != null) {
            if (string == null) {
                this.writer = new OutputStreamWriter(this.out);
                return;
            }
            this.writer = new OutputStreamWriter(this.out, string);
        }
    }

    protected void setOutputStream(OutputStream outputStream) throws SecurityException {
        LogManager.getLogManager().checkAccess();
        outputStream.getClass();
        try {
            this.changeWriter(outputStream, this.getEncoding());
            return;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException.getMessage());
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        String string;
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (this.streamState == 0) {
            try {
                this.writer.write(this.formatter.getHead(this));
            }
            catch (IOException iOException) {
                this.reportError(null, iOException, 1);
                return;
            }
            catch (Exception exception) {
                this.reportError(null, exception, 0);
                return;
            }
            this.streamState = 1;
        }
        try {
            string = this.formatter.format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 5);
            return;
        }
        try {
            this.writer.write(string);
            return;
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
            return;
        }
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        return this.writer != null && super.isLoggable(logRecord);
    }

    @Override
    public void flush() {
        try {
            this.checkOpen();
            if (this.writer != null) {
                this.writer.flush();
                return;
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 2);
        }
    }

    @Override
    public void close() throws SecurityException {
        LogManager.getLogManager().checkAccess();
        try {
            this.checkOpen();
            this.flush();
            if (this.writer != null) {
                if (this.formatter != null) {
                    if (this.streamState == 0) {
                        this.writer.write(this.formatter.getHead(this));
                    }
                    if (this.streamState != 2) {
                        this.writer.write(this.formatter.getTail(this));
                    }
                }
                this.streamState = 2;
                this.writer.close();
                return;
            }
        }
        catch (Exception exception) {
            this.reportError(null, exception, 3);
        }
    }

    private /* synthetic */ void Block$() {
        this.streamState = 0;
    }
}

