/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.regexp.REMatch;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Matcher {
    private Pattern pattern;
    private CharSequence input;
    private int position;
    private int appendPosition;
    private REMatch match;

    public Pattern pattern() {
        return this.pattern;
    }

    Matcher(Pattern pattern, CharSequence charSequence) {
        this.pattern = pattern;
        this.input = charSequence;
    }

    public boolean matches() {
        return this.find(0);
    }

    public boolean lookingAt() {
        this.match = this.pattern.getRE().getMatch(this.input, 0);
        if (this.match != null) {
            if (this.match.getStartIndex() == 0) {
                return true;
            }
            this.match = null;
        }
        return false;
    }

    public boolean find() {
        return this.find(this.position);
    }

    public boolean find(int n) {
        this.match = this.pattern.getRE().getMatch(this.input, n);
        if (this.match != null) {
            this.position = this.match.getEndIndex();
            return true;
        }
        return false;
    }

    private void assertMatchOp() {
        if (this.match == null) {
            throw new IllegalStateException();
        }
    }

    public int start() {
        this.assertMatchOp();
        return this.match.getStartIndex();
    }

    public int start(int n) {
        this.assertMatchOp();
        return this.match.getStartIndex(n);
    }

    public int end() {
        this.assertMatchOp();
        return this.match.getEndIndex();
    }

    public int end(int n) {
        this.assertMatchOp();
        return this.match.getEndIndex(n);
    }

    public String group() {
        this.assertMatchOp();
        return this.match.toString();
    }

    public String group(int n) {
        this.assertMatchOp();
        return this.match.toString(n);
    }

    public int groupCount() {
        return this.pattern.getRE().getNumSubs();
    }

    public Matcher appendReplacement(StringBuffer stringBuffer, String string) {
        this.assertMatchOp();
        stringBuffer.append(this.input.subSequence(this.appendPosition, this.match.getStartIndex()).toString());
        stringBuffer.append(this.match.substituteInto(string));
        this.appendPosition = this.match.getEndIndex();
        return this;
    }

    public StringBuffer appendTail(StringBuffer stringBuffer) {
        stringBuffer.append(this.input.subSequence(this.appendPosition, this.input.length()).toString());
        return stringBuffer;
    }

    public String replaceAll(String string) {
        this.reset();
        return this.pattern.getRE().substituteAll(this.input, string, this.position);
    }

    public String replaceFirst(String string) {
        this.reset();
        return this.pattern.getRE().substitute(this.input, string, this.position);
    }

    public Matcher reset() {
        this.position = 0;
        this.match = null;
        return this;
    }

    public Matcher reset(CharSequence charSequence) {
        this.input = charSequence;
        this.reset();
        return this;
    }
}

