/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GZIPInputStream
extends InflaterInputStream {
    protected CRC32 crc;
    protected boolean eos;
    private InputStream strm;
    public static final int GZIP_MAGIC = 8075;
    static final int OLD_GZIP_MAGIC = 8094;
    static final int GZIP_FLAG_ASCII_FLAG = 1;
    static final int GZIP_FLAG_CONTINUATION = 2;
    static final int GZIP_FLAG_EXTRA_FIELD = 4;
    static final int GZIP_FLAG_ORIG_NAME = 8;
    static final int GZIP_FLAG_COMMENT = 16;
    static final int GZIP_FLAG_ENCRYPTED = 32;
    static final int GZIP_FLAG_RESERVED = 192;

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
        this.strm = inputStream;
        this.crc = new CRC32();
        this.eos = false;
        this.checkBytes(new int[]{31, 31});
        this.checkBytes(new int[]{139, 158});
        this.checkBytes(new int[]{8});
        int n2 = this.checkBytes(null);
        this.ignoreBytes(6);
        if ((n2 & 2) != 0) {
            this.ignoreBytes(2);
        }
        if ((n2 & 4) != 0) {
            int n3 = this.strm.read();
            this.ignoreBytes(n3 |= this.strm.read() << 8);
        }
        if ((n2 & 8) != 0) {
            this.ignoreString();
        }
        if ((n2 & 0x10) != 0) {
            this.ignoreString();
        }
    }

    private int checkBytes(int[] nArray) throws IOException {
        int n = this.strm.read();
        if (nArray != null) {
            int n2 = 0;
            while (n2 < nArray.length && n != nArray[n2]) {
                ++n2;
            }
            if (n2 == nArray.length) {
                throw new IOException("invalid GZIP stream");
            }
        }
        return n;
    }

    private void ignoreBytes(int n) throws IOException {
        while (n > 0) {
            this.strm.read();
            --n;
        }
    }

    private void ignoreString() throws IOException {
        int n;
        while ((n = this.strm.read()) != 0) {
            if (n != -1) continue;
            throw new IOException("premature GZIP end-of-file");
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 > 0) {
            this.crc.update(byArray, n, n3);
        } else if (n3 == -1 && !this.eos) {
            this.eos = true;
            this.ignoreBytes(8);
        }
        return n3;
    }
}

