/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InflaterInputStream
extends FilterInputStream {
    private static final int DEFAULT = 512;
    protected Inflater inf;
    protected byte[] buf;
    protected int len;

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater(), 512);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        if (inputStream == null) {
            throw new NullPointerException("in");
        }
        if (inflater == null) {
            throw new NullPointerException("inf");
        }
        this.inf = inflater;
        if (n < 1) {
            throw new IllegalArgumentException("size < 1");
        }
        this.buf = new byte[n];
    }

    protected void fill() throws IOException {
        this.len = super.read(this.buf, 0, this.buf.length);
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        if (n == -1) {
            return -1;
        }
        return byArray[0];
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.inf.finished()) {
            return -1;
        }
        if (this.inf.needsInput()) {
            this.fill();
            if (this.len == -1) {
                return -1;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }
        try {
            int n3 = 0;
            while ((n3 += this.inf.inflate(byArray, n + n3, n2 - n3)) < n2 && !this.inf.needsInput() && !this.inf.finished()) {
            }
            if (n3 == 0 && n2 != 0) {
                return this.read(byArray, n, n2);
            }
            return n3;
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("bad data format");
        }
    }

    @Override
    public long skip(long l) throws IOException {
        byte[] byArray = new byte[1];
        long l2 = 0L;
        while (l2 < l) {
            int n = this.read(byArray, 0, 1);
            if (n == -1) break;
            ++l2;
        }
        return l2;
    }
}

