/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import kaffe.util.UTF8;
import kaffe.util.zip.SwitchInflater;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipInputStream
extends InflaterInputStream
implements ZipConstants {
    private byte[] sigbuf;
    private byte[] zheader;
    private byte[] dheader;
    private boolean gotSig;
    private SwitchInflater sinf;
    private ZipEntry entry;

    public ZipInputStream(InputStream inputStream) {
        super(inputStream, new SwitchInflater(true, true));
        this.Block$();
        this.sinf = (SwitchInflater)this.inf;
        this.sinf.reset();
        this.sinf.setMode(true);
        this.sinf.setLength(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getNextEntry() throws IOException {
        this.closeEntry();
        ZipInputStream zipInputStream = this;
        synchronized (zipInputStream) {
            int n = this.readSig();
            switch (n) {
                case 33639248: {
                    return null;
                }
                case 67324752: {
                    break;
                }
                default: {
                    throw new IOException(new StringBuffer().append("Bogus signature: 0x").append(Integer.toHexString(n)).toString());
                }
            }
            this.readFully(this.zheader, this.sigbuf.length, this.zheader.length - this.sigbuf.length);
            byte[] byArray = new byte[this.get16(this.zheader, 26)];
            this.readFully(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[this.get16(this.zheader, 28)];
            this.readFully(byArray2, 0, byArray2.length);
            this.entry = new ZipEntry(UTF8.decode(byArray));
            this.entry.version = this.get16(this.zheader, 4);
            this.entry.flag = this.get16(this.zheader, 6);
            this.entry.setMethod(this.get16(this.zheader, 8));
            this.entry.setDosTime(this.get32(this.zheader, 10));
            this.entry.setCrc((long)this.get32(this.zheader, 14) & 0xFFFFFFFFL);
            this.entry.setCompressedSize((long)this.get32(this.zheader, 18) & 0xFFFFFFFFL);
            this.entry.setSize((long)this.get32(this.zheader, 22) & 0xFFFFFFFFL);
            this.entry.setExtra(byArray2);
            this.entry.setComment("");
            this.entry.offset = 0L;
            if (this.entry.method == 0) {
                this.sinf.setMode(true);
                this.sinf.setLength((int)this.entry.csize);
            } else {
                this.sinf.setMode(false);
            }
            return this.entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEntry() throws IOException {
        ZipInputStream zipInputStream = this;
        synchronized (zipInputStream) {
            block8: {
                if (this.entry == null) {
                    return;
                }
                try {
                    byte[] byArray = new byte[512];
                    while (this.read(byArray, 0, byArray.length) != -1) {
                    }
                    this.sinf.reset();
                    this.sinf.setMode(true);
                    this.sinf.setLength(Integer.MAX_VALUE);
                    if (this.entry.method != 8 || this.peekSig() != 134695760) break block8;
                    this.readSig();
                    this.readFully(this.dheader, this.sigbuf.length, this.dheader.length - this.sigbuf.length);
                    int n = this.get32(this.dheader, 4);
                    this.entry.setCrc((long)n & 0xFFFFFFFFL);
                    int n2 = this.get32(this.dheader, 8);
                    this.entry.setCompressedSize((long)n2 & 0xFFFFFFFFL);
                    int n3 = this.get32(this.dheader, 12);
                    if (n == 0 && n3 != 0) {
                        throw new IOException(new StringBuffer().append("CRC error: data_crc=0, data_csize=").append(n2).append(",data_size=").append(n3).toString());
                    }
                    this.entry.setSize((long)n3 & 0xFFFFFFFFL);
                }
                catch (Throwable throwable) {
                    Object var3_7 = null;
                    this.entry = null;
                    throw throwable;
                }
            }
            Object var3_6 = null;
            this.entry = null;
            return;
        }
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return super.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        return super.skip(l);
    }

    @Override
    public void close() throws IOException {
        this.closeEntry();
        super.close();
    }

    private int get16(byte[] byArray, int n) {
        int n2 = byArray[n] & 0xFF;
        return n2 |= (byArray[n + 1] & 0xFF) << 8;
    }

    private int get32(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8 | (byArray[n + 2] & 0xFF) << 16 | (byArray[n + 3] & 0xFF) << 24;
    }

    private void readFully(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n2;
        while (n3 > 0) {
            int n4 = this.read(byArray, n, n3);
            if (n4 == -1) {
                if (n3 != 0) {
                    throw new IOException(new StringBuffer().append("truncated file (only read ").append(n2 - n3).append("/").append(n2).append(")").toString());
                }
                return;
            }
            n += n4;
            n3 -= n4;
        }
    }

    private int readSig() throws IOException {
        int n = this.peekSig();
        this.gotSig = false;
        return n;
    }

    private int peekSig() throws IOException {
        if (!this.gotSig) {
            this.readFully(this.sigbuf, 0, this.sigbuf.length);
            this.gotSig = true;
        }
        return this.get32(this.sigbuf, 0);
    }

    protected ZipEntry createZipEntry(String string) {
        return null;
    }

    private /* synthetic */ void Block$() {
        this.sigbuf = new byte[4];
        this.zheader = new byte[30];
        this.dheader = new byte[16];
    }
}

