/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import org.tritonus.core.TMidiConfig;
import org.tritonus.share.ArraySet;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiSystem {
    private static final MidiDevice.Info[] EMPTY_MIDIDEVICE_INFO_ARRAY = new MidiDevice.Info[0];

    public static MidiDevice.Info[] getMidiDeviceInfo() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = TMidiConfig.getMidiDeviceProviders();
        while (iterator.hasNext()) {
            MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)iterator.next();
            Object[] objectArray = midiDeviceProvider.getDeviceInfo();
            arrayList.addAll(Arrays.asList(objectArray));
        }
        return (MidiDevice.Info[])arrayList.toArray(EMPTY_MIDIDEVICE_INFO_ARRAY);
    }

    public static MidiDevice getMidiDevice(MidiDevice.Info info) throws MidiUnavailableException {
        Iterator iterator = TMidiConfig.getMidiDeviceProviders();
        Object var2_2 = null;
        while (iterator.hasNext()) {
            MidiDeviceProvider midiDeviceProvider = (MidiDeviceProvider)iterator.next();
            try {
                return midiDeviceProvider.getDevice(info);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(illegalArgumentException);
            }
        }
        throw new MidiUnavailableException(new StringBuffer().append("no device found for ").append(info).toString());
    }

    public static Receiver getReceiver() throws MidiUnavailableException {
        MidiDevice.Info info = TMidiConfig.getDefaultMidiDeviceInfo();
        MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
        if (!midiDevice.isOpen()) {
            midiDevice.open();
        }
        Receiver receiver = midiDevice.getReceiver();
        return receiver;
    }

    public static Transmitter getTransmitter() throws MidiUnavailableException {
        MidiDevice.Info info = TMidiConfig.getDefaultMidiDeviceInfo();
        MidiDevice midiDevice = MidiSystem.getMidiDevice(info);
        if (!midiDevice.isOpen()) {
            midiDevice.open();
        }
        Transmitter transmitter = midiDevice.getTransmitter();
        return transmitter;
    }

    public static Synthesizer getSynthesizer() throws MidiUnavailableException {
        MidiDevice.Info info = TMidiConfig.getDefaultSynthesizerInfo();
        if (TDebug.TraceMidiSystem) {
            TDebug.out(new StringBuffer().append("MidiSystem.getSynthesizer(): using default synthesizer info: ").append(info).toString());
        }
        Synthesizer synthesizer = (Synthesizer)MidiSystem.getMidiDevice(info);
        return synthesizer;
    }

    public static Sequencer getSequencer() throws MidiUnavailableException {
        MidiDevice.Info info = TMidiConfig.getDefaultSequencerInfo();
        if (TDebug.TraceMidiSystem) {
            TDebug.out(new StringBuffer().append("MidiSystem.getSequencer(): using: ").append(info).toString());
        }
        Sequencer sequencer = (Sequencer)MidiSystem.getMidiDevice(info);
        return sequencer;
    }

    public static Soundbank getSoundbank(InputStream inputStream) throws InvalidMidiDataException, IOException {
        return null;
    }

    public static Soundbank getSoundbank(URL uRL) throws InvalidMidiDataException, IOException {
        return null;
    }

    public static Soundbank getSoundbank(File file) throws InvalidMidiDataException, IOException {
        return null;
    }

    public static MidiFileFormat getMidiFileFormat(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Iterator iterator = TMidiConfig.getMidiFileReaders();
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            try {
                return midiFileReader.getMidiFileFormat(inputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(illegalArgumentException);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static MidiFileFormat getMidiFileFormat(URL uRL) throws InvalidMidiDataException, IOException {
        Iterator iterator = TMidiConfig.getMidiFileReaders();
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            try {
                return midiFileReader.getMidiFileFormat(uRL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(illegalArgumentException);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static MidiFileFormat getMidiFileFormat(File file) throws InvalidMidiDataException, IOException {
        Iterator iterator = TMidiConfig.getMidiFileReaders();
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            try {
                return midiFileReader.getMidiFileFormat(file);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(illegalArgumentException);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static Sequence getSequence(InputStream inputStream) throws InvalidMidiDataException, IOException {
        Iterator iterator = TMidiConfig.getMidiFileReaders();
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            try {
                return midiFileReader.getSequence(inputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(illegalArgumentException);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static Sequence getSequence(URL uRL) throws InvalidMidiDataException, IOException {
        Iterator iterator = TMidiConfig.getMidiFileReaders();
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            try {
                return midiFileReader.getSequence(uRL);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(illegalArgumentException);
            }
        }
        throw new InvalidMidiDataException();
    }

    public static Sequence getSequence(File file) throws InvalidMidiDataException, IOException {
        Iterator iterator = TMidiConfig.getMidiFileReaders();
        if (TDebug.TraceMidiSystem) {
            TDebug.out(new StringBuffer().append("MidiSystem.getSequence(File): got readers: ").append(iterator).toString());
        }
        while (iterator.hasNext()) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            if (TDebug.TraceMidiSystem) {
                TDebug.out(new StringBuffer().append("MidiSystem.getSequence(File): Trying MidiFileReader ").append(midiFileReader).toString());
            }
            try {
                return midiFileReader.getSequence(file);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (!TDebug.TraceAllExceptions) continue;
                TDebug.out(illegalArgumentException);
            }
        }
        if (TDebug.TraceMidiSystem) {
            TDebug.out("MidiSystem.getSequence(File): no appropriate MidiFileReader found, throwing exception");
        }
        throw new InvalidMidiDataException();
    }

    public static int[] getMidiFileTypes() {
        int n;
        Object object;
        Object object2;
        ArraySet arraySet = new ArraySet();
        Iterator iterator = TMidiConfig.getMidiFileWriters();
        while (iterator.hasNext()) {
            object2 = (MidiFileWriter)iterator.next();
            object = ((MidiFileWriter)object2).getMidiFileTypes();
            n = 0;
            while (n < ((Object)object).length) {
                arraySet.add(new Integer((int)object[n]));
                ++n;
            }
        }
        object2 = new int[arraySet.size()];
        object = arraySet.iterator();
        n = 0;
        while (object.hasNext()) {
            Integer n2 = (Integer)object.next();
            object2[n] = n2;
            ++n;
        }
        return object2;
    }

    public static boolean isFileTypeSupported(int n) {
        Iterator iterator = TMidiConfig.getMidiFileWriters();
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)iterator.next();
            boolean bl = midiFileWriter.isFileTypeSupported(n);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static int[] getMidiFileTypes(Sequence sequence) {
        int n;
        Object object;
        Object object2;
        ArraySet arraySet = new ArraySet();
        Iterator iterator = TMidiConfig.getMidiFileWriters();
        while (iterator.hasNext()) {
            object2 = (MidiFileWriter)iterator.next();
            object = ((MidiFileWriter)object2).getMidiFileTypes(sequence);
            n = 0;
            while (n < ((Object)object).length) {
                arraySet.add(new Integer((int)object[n]));
                ++n;
            }
        }
        object2 = new int[arraySet.size()];
        object = arraySet.iterator();
        n = 0;
        while (object.hasNext()) {
            Integer n2 = (Integer)object.next();
            object2[n] = n2;
            ++n;
        }
        return object2;
    }

    public static boolean isFileTypeSupported(int n, Sequence sequence) {
        Iterator iterator = TMidiConfig.getMidiFileWriters();
        while (iterator.hasNext()) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)iterator.next();
            boolean bl = midiFileWriter.isFileTypeSupported(n, sequence);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    public static int write(Sequence sequence, int n, OutputStream outputStream) throws IOException {
        return MidiSystem.writeImpl(sequence, n, outputStream);
    }

    public static int write(Sequence sequence, int n, File file) throws IOException {
        return MidiSystem.writeImpl(sequence, n, file);
    }

    private static int writeImpl(Sequence sequence, int n, Object object) throws IOException {
        WriteMidiFileWriterAction writeMidiFileWriterAction = new WriteMidiFileWriterAction(sequence, n, object);
        MidiSystem.doMidiFileWriterIteration(writeMidiFileWriterAction);
        int n2 = writeMidiFileWriterAction.getWritten();
        if (n2 == -1) {
            throw new IllegalArgumentException("format not  supported");
        }
        return n2;
    }

    private static void doMidiFileReaderIteration(MidiFileReaderAction midiFileReaderAction) throws IOException {
        Iterator iterator = TMidiConfig.getMidiFileReaders();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            MidiFileReader midiFileReader = (MidiFileReader)iterator.next();
            if (TDebug.TraceMidiSystem) {
                TDebug.out(new StringBuffer().append("MidiSystem.doMidiFileReaderIteration(): handling MidiFileReader: ").append(midiFileReader).toString());
            }
            bl = midiFileReaderAction.handleMidiFileReader(midiFileReader);
        }
    }

    private static void doMidiFileWriterIteration(MidiFileWriterAction midiFileWriterAction) throws IOException {
        Iterator iterator = TMidiConfig.getMidiFileWriters();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            MidiFileWriter midiFileWriter = (MidiFileWriter)iterator.next();
            if (TDebug.TraceMidiSystem) {
                TDebug.out(new StringBuffer().append("MidiSystem.doMidiFileWriterIteration(): handling MidiFileWriter: ").append(midiFileWriter).toString());
            }
            bl = midiFileWriterAction.handleMidiFileWriter(midiFileWriter);
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WriteMidiFileWriterAction
    implements MidiFileWriterAction {
        private Sequence m_sequence;
        private int m_fileType;
        private Object m_destination;
        private int m_nWritten;

        public WriteMidiFileWriterAction(Sequence sequence, int n, Object object) {
            this.m_sequence = sequence;
            this.m_fileType = n;
            this.m_destination = object;
            this.m_nWritten = -1;
        }

        @Override
        public boolean handleMidiFileWriter(MidiFileWriter midiFileWriter) throws IOException {
            int n = -1;
            if (!midiFileWriter.isFileTypeSupported(this.m_fileType)) {
                return false;
            }
            try {
                if (this.m_destination instanceof OutputStream) {
                    n = midiFileWriter.write(this.m_sequence, this.m_fileType, (OutputStream)this.m_destination);
                } else if (this.m_destination instanceof File) {
                    n = midiFileWriter.write(this.m_sequence, this.m_fileType, (File)this.m_destination);
                }
                this.m_nWritten = n;
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (TDebug.TraceMidiSystem || TDebug.TraceAllExceptions) {
                    TDebug.out(illegalArgumentException);
                }
                return false;
            }
        }

        public int getWritten() {
            return this.m_nWritten;
        }
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MidiFileReaderAction {
        public boolean handleMidiFileReader(MidiFileReader var1) throws IOException;
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface MidiFileWriterAction {
        public boolean handleMidiFileWriter(MidiFileWriter var1) throws IOException;
    }
}

