/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioFormat {
    protected Encoding encoding;
    protected float sampleRate;
    protected int sampleSizeInBits;
    protected int channels;
    protected int frameSize;
    protected float frameRate;
    protected boolean bigEndian;

    public AudioFormat(Encoding encoding, float f, int n, int n2, int n3, float f2, boolean bl) {
        this.encoding = encoding;
        this.sampleRate = f;
        this.sampleSizeInBits = n;
        this.channels = n2;
        this.frameSize = n3;
        this.frameRate = f2;
        this.bigEndian = bl;
    }

    public AudioFormat(float f, int n, int n2, boolean bl, boolean bl2) {
        this(bl ? Encoding.PCM_SIGNED : Encoding.PCM_UNSIGNED, f, n, n2, n2 != -1 && n != -1 ? n2 * n / 8 : -1, f, bl2);
    }

    public Encoding getEncoding() {
        return this.encoding;
    }

    public float getSampleRate() {
        return this.sampleRate;
    }

    public int getSampleSizeInBits() {
        return this.sampleSizeInBits;
    }

    public int getChannels() {
        return this.channels;
    }

    public int getFrameSize() {
        return this.frameSize;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }

    private static boolean doMatch(int n, int n2) {
        return n == -1 || n2 == -1 || n == n2;
    }

    private static boolean doMatch(float f, float f2) {
        return f == -1.0f || f2 == -1.0f || (double)Math.abs(f - f2) < 1.0E-9;
    }

    public boolean matches(AudioFormat audioFormat) {
        return this.getEncoding().equals(audioFormat.getEncoding()) && (audioFormat.getSampleSizeInBits() <= 8 || audioFormat.getSampleSizeInBits() == -1 || this.isBigEndian() == audioFormat.isBigEndian()) && AudioFormat.doMatch(this.getChannels(), audioFormat.getChannels()) && AudioFormat.doMatch(this.getSampleSizeInBits(), audioFormat.getSampleSizeInBits()) && AudioFormat.doMatch(this.getFrameSize(), audioFormat.getFrameSize()) && AudioFormat.doMatch(this.getSampleRate(), audioFormat.getSampleRate()) && AudioFormat.doMatch(this.getFrameRate(), audioFormat.getFrameRate());
    }

    public String toString() {
        return new StringBuffer().append(this.getEncoding()).append(", ").append(this.getChannels()).append(" channel(s), ").append(this.getSampleSizeInBits()).append(" bit samples, ").append(this.getFrameSize()).append(" byte frames, ").append(this.getSampleRate()).append(" Hz, ").append(this.getFrameRate()).append(" frames/second, ").append(this.isBigEndian() ? "big endian" : "little endian").toString();
    }

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Encoding {
        public static final Encoding PCM_SIGNED = new Encoding("PCM_SIGNED");
        public static final Encoding PCM_UNSIGNED = new Encoding("PCM_UNSIGNED");
        public static final Encoding ULAW = new Encoding("ULAW");
        public static final Encoding ALAW = new Encoding("ALAW");
        private String m_strName;

        protected Encoding(String string) {
            this.m_strName = string;
        }

        public final boolean equals(Object object) {
            return super.equals(object);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        public final String toString() {
            return this.m_strName;
        }
    }
}

