/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.Line;
import org.tritonus.share.TDebug;

/*
 * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Port
extends Line {

    /*
     * This class specifies class file version 45.3 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Info
    extends Line.Info {
        public static final Info MICROPHONE = new Info(Info.getPortClass(), "MICROPHONE", true);
        public static final Info LINE_IN = new Info(Info.getPortClass(), "LINE_IN", true);
        public static final Info COMPACT_DISC = new Info(Info.getPortClass(), "COMPACT_DISC", true);
        public static final Info SPEAKER = new Info(Info.getPortClass(), "SPEAKER", false);
        public static final Info HEADPHONE = new Info(Info.getPortClass(), "HEADPHONE", false);
        public static final Info LINE_OUT = new Info(Info.getPortClass(), "LINE_OUT", false);
        private String m_strName;
        private boolean m_bIsSource;

        public static Class getPortClass() {
            try {
                return Class.forName("javax.sound.sampled.Port");
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (TDebug.TraceAllExceptions) {
                    TDebug.out(classNotFoundException);
                }
                return null;
            }
        }

        public Info(Class clazz, String string, boolean bl) {
            super(clazz);
            this.m_strName = string;
            this.m_bIsSource = bl;
        }

        public String getName() {
            return this.m_strName;
        }

        public boolean isSource() {
            return this.m_bIsSource;
        }

        @Override
        public boolean matches(Line.Info info) {
            return super.matches(info) && this.getName().equals(((Info)info).getName()) && this.isSource() == ((Info)info).isSource();
        }

        public final boolean equals(Object object) {
            return super.equals(object);
        }

        public final int hashCode() {
            return super.hashCode();
        }

        @Override
        public final String toString() {
            return new StringBuffer().append(super.toString()).append("[name=").append(this.getName()).append(", source = ").append(this.isSource()).append("]").toString();
        }
    }
}

